/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sf.pal.weather ;

import java.io.IOException;
import java.util.* ;
import javax.portlet.*;

/**
 * Weather Portlet
 * 
 * @version $Id: WeatherPortlet.java,v 1.5 2006/04/24 06:53:30 karma Exp $
 * @author KATOH Yasufumi
 */
public class WeatherPortlet extends GenericPortlet
{
    public static final String CITYID_PARAM_NAME = "id" ;
    public static final String CITY_PARAM_NAME = "city" ;
    public static final String CITY_PARAM_DEFAULT = "default" ;
    public static final String WEATHER_BEAN_KEY = "weather" ;

    /**
     * @see javax.portlet.Portlet#init(javax.portlet.PortletConfig)
     */
    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);
    }

    /**
     * @see javax.portlet.GenericPortlet#doView(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException
    {
        response.setContentType("text/html");        
        PortletContext context = getPortletContext();

        // PortletPreferences から表示したい都市の id を取得
        PortletPreferences  prefs = request.getPreferences() ;
        String id = prefs.getValue(CITY_PARAM_NAME, null) ;
        
        // WebService から天気情報を取得
        WeatherWebService webService = new WeatherWebService(id, WeatherWebService.TODAY) ;
        Weather weather = webService.getWeather() ;
        Map cityMap = webService.getCityMap() ;
        
        // 属性に天気オブジェクトと都市Mapをセット
        request.setAttribute(WEATHER_BEAN_KEY, weather) ;
        request.setAttribute(CITY_PARAM_NAME, cityMap) ;
        request.setAttribute(CITYID_PARAM_NAME, id) ;
        
        // inclde JSP
        PortletRequestDispatcher rd = context.getRequestDispatcher("/WEB-INF/view/weather.jsp");
        rd.include(request, response);
    }
    
    /**
     * @see javax.portlet.Portlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
    	throws PortletException, IOException {
    
        // 天気を表示したい都市のidの取得
        String id = request.getParameter(CITY_PARAM_NAME);
        
        // PortletPreferencesの取得
        PortletPreferences  prefs = request.getPreferences() ;
        
        // 取得する都市の指定がない場合
        if (id == null || id.equals(CITY_PARAM_DEFAULT)) {
            id = prefs.getValue(CITY_PARAM_NAME, null) ;
        } 

        // Preference に都市 id をセット
        prefs.setValue(CITY_PARAM_NAME, id) ;
        
        // Store
        prefs.store() ;
    	
    }
    
}
