/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.dao;

import java.util.List;

import jp.sf.pal.blog.model.BlogComment;

public interface BlogCommentDao
{
    public Class BEAN = BlogComment.class;

    //add, update, delete
    public void save(BlogComment bc);

    public void delete(BlogComment bc);

    public void update(BlogComment bc);

    public void saveOrUpdate(BlogComment bc);

    // By id
    public String getBlogCommentById_ARGS = "id";

    public BlogComment getBlogCommentById(long id);

    // All BlogComment
    public List getAllBlogComment();

}
