/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jstock.util;

import java.text.MessageFormat;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

import org.seasar.portlet.util.PortletResourceBundleUtil;

public class MessageUtil {
    
    /**
     * 指定した MessageID からエラーメッセージ文字列を生成する．
     * @param messageId id
     * @param args メッセージに含める引数
     * @return エラーメッセージ
     */
    public static String getErrorMessage(String messageId, Object[] args) {
        String pattern = PortletResourceBundleUtil.getString(LocaleUtil.getLocale(), messageId);
        return MessageFormat.format(pattern, args);
    }
    
    /**
     * エラーメッセージを FacesContext に追加する．
     * @param messageId メッセージのキー
     * @param args メッセージに含めるパラメータ
     */
    public static void addErrorMessage(String messageId, Object[] args) {

        String message = getErrorMessage(messageId, args);
        FacesMessage facesMessage = new FacesMessage(message);
        
        FacesContext.getCurrentInstance().addMessage(null, facesMessage);
    }

}
