/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jstock;

import java.util.List;

import org.seasar.extension.unit.S2TestCase;

import jp.sf.pal.jstock.reader.StockDataReader;
import jp.sf.pal.jstock.util.ComponentUtil;

public class LivedoorStockDataReaderTest extends S2TestCase {

    private static final String PATH = "jstock.dicon";
    private StockDataReader reader;

    protected void setUp() throws Exception {
        super.setUp();
        include(PATH);
        reader = ComponentUtil.getReader();
    }

    public void testGetStockData() throws Exception {
        List list = reader.getStockDataList();
        assertEquals("TEST", list.size(), 2);
    }

}
