/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.bean;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;

import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.NotepadRuntimeException;
import jp.sf.pal.notepad.model.Category;
import jp.sf.pal.notepad.util.NotepadDaoUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.model.S2HibernateDataModel;
import com.marevol.utils.faces.util.LocaleUtil;

public class CategoryViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(CategoryViewPageBean.class);

    private NotepadSessionBean notepadSession;

    private String name;

    private String description;

    public String create()
    {
        try
        {
            String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
            if (username == null)
            {
                username = NotepadConstants.GUEST_USER;
            }
            Category cat = new Category();
            cat.setCreatedtime(Calendar.getInstance().getTime());
            cat.setDescription(getDescription());
            cat.setName(getName());
            cat.setOwner(username);
            cat.setScope(getNotepadSession().getScope());

            NotepadDaoUtil.getCategoryDao().save(cat);

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "categoryview.AddedTheCategory"));
        }
        catch (NotepadRuntimeException e)
        {
            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "categoryview.FailedToAddTheCategory"));
            log.error("Failed to add it.", e);
        }
        catch (RuntimeException e)
        {
            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "categoryview.FailedToAddTheCategory"));
            log.error("Failed to add it.", e);
        }

        return null;
    }

    public String detail()
    {
        ExternalContext exContext = FacesContext.getCurrentInstance().getExternalContext();
        Map map = exContext.getRequestMap();
        Map catMap = (Map) map.get("category");
        Category cat = (Category) catMap.get("0");
        if (cat != null)
        {
            getNotepadSession().setCategory(cat);
            return NotepadConstants.CATEGORY_EDIT_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addWarnMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "categoryview.TheSelectedItemIsNull"));
            log.error("The selected Item is null.");
        }
        return null;
    }

    /**
     * @return Returns the note items.
     */
    public DataModel getCategories()
    {
        StringBuffer query = new StringBuffer("select cat from Category cat ");
        String param = "where ";
        ArrayList paramList = new ArrayList();

        query.append(param);
        query.append("cat.scope = ? ");
        param = "and ";
        paramList.add(getNotepadSession().getScope());

        String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if (username != null)
        {
            query.append(param);
            query.append("cat.owner = ? ");
            param = "and ";
            paramList.add(username);
        }
        else
        {
            query.append(param);
            query.append("cat.owner = ? ");
            param = "and ";
            paramList.add(NotepadConstants.GUEST_USER);
        }

        query.append("order by cat.name");

        if (log.isDebugEnabled())
        {
            log.debug("getNotes() -  : query=" + query.toString());
        }

        Object[] params = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); i++)
        {
            params[i] = paramList.get(i);
        }

        return new S2HibernateDataModel(query.toString(), params);
    }

    /**
     * @return Returns the notepadSession.
     */
    public NotepadSessionBean getNotepadSession()
    {
        return notepadSession;
    }

    /**
     * @param notepadSession The notepadSession to set.
     */
    public void setNotepadSession(NotepadSessionBean notepadSession)
    {
        this.notepadSession = notepadSession;
    }

    /**
     * @return Returns the description.
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @param description The description to set.
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * @return Returns the name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name The name to set.
     */
    public void setName(String name)
    {
        this.name = name;
    }
}
