<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.notepad.resources.NotepadResources"
		var="msgs" />

	<!-- Menu -->
	<f:subview id="menu">
		<jsp:include page="Menubar.jsp" />
	</f:subview>

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="2">

			<h:outputLabel for="name">
				<h:outputText value="#{msgs['categoryeditpage.Name']}" />
			</h:outputLabel>
			<h:inputText id="name" value="#{categoryEditPage.name}"
				required="true" />

			<h:outputLabel for="description">
				<h:outputText value="#{msgs['categoryeditpage.Description']}" />
			</h:outputLabel>
			<h:inputText id="description" value="#{categoryEditPage.description}" />

		</h:panelGrid>

		<h:inputHidden value="#{categoryEditPage.id}" />

		<h:panelGrid columns="3">
			<h:commandButton action="#{categoryEditPage.update}" value="#{msgs['categoryeditpage.Update']}"
				rendered="#{notepadMenuPage.validUser}" />
			<h:commandButton action="#{categoryEditPage.delete}" value="#{msgs['categoryeditpage.Delete']}"
				rendered="#{notepadMenuPage.validUser}" />
			<h:commandButton action="#{categoryEditPage.back}" value="#{msgs['categoryeditpage.Back']}"
				immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
