<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.notepad.resources.NotepadResources"
		var="msgs" />

	<!-- Menu -->
	<f:subview id="menu">
		<jsp:include page="Menubar.jsp" />
	</f:subview>

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="5">

			<h:outputLabel for="name">
				<h:outputText value="#{msgs['categoryviewpage.Name']}" />
			</h:outputLabel>
			<h:inputText id="name" value="#{categoryViewPage.name}"
				required="true" />

			<h:outputLabel for="description">
				<h:outputText value="#{msgs['categoryviewpage.Description']}" />
			</h:outputLabel>
			<h:inputText id="description" value="#{categoryViewPage.description}" />

			<h:commandButton type="submit" action="#{categoryViewPage.create}"
				value="#{msgs['categoryviewpage.Create']}" />

		</h:panelGrid>
	</h:form>
	
	<h:form>
		<t:dataTable id="categoryList" var="category"
			value="#{categoryViewPage.categories}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{notepadSession.pageSize}">
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['categoryviewpage.table.Name']}" />
				</f:facet>
				<h:commandLink action="#{categoryViewPage.detail}"
					value="#{category['0'].name}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['categoryviewpage.table.Description']}" />
				</f:facet>
				<h:outputText value="#{category['0'].description}" />
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="categoryList" fastStep="10"
				pageCountVar="pageCount" pageIndexVar="pageIndex" paginator="true"
				paginatorMaxPages="9">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="categoryList" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				firstRowIndexVar="firstRowIndex" lastRowIndexVar="lastRowIndex"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['categoryviewpage.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['categoryviewpage.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>

	</h:form>

</f:view>
