/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.tomahawk.resourcehandler;

import java.io.IOException;
import javax.portlet.PortletContext;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import jp.sf.pal.tomahawk.resourcehandler.ResourceHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultResourceHandler
implements ResourceHandler {
    private static final Log log = LogFactory.getLog((Class)DefaultResourceHandler.class);
    private PortletContext portletContext;
    protected String resourcesInHead = "";
    protected String resourcesBeforeContents = "";
    protected String resourcesAfterContents = "";

    public void init() {
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void parse(String htmlContents) {
        this.resourcesInHead = this.getStringInTag(htmlContents, "<head>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) - resourcesInHead=" + this.resourcesInHead));
        }
        if (this.resourcesInHead == null) {
            this.resourcesInHead = "";
        }
        String body = this.getStringInTag(htmlContents, "<body>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) - body=" + body));
        }
        if (body != null) {
            int startIndex = body.indexOf(ResourceHandler.BODY_CONTENTS);
            if (startIndex > 0) {
                this.resourcesBeforeContents = body.substring(0, startIndex);
                this.resourcesAfterContents = body.substring(startIndex + ResourceHandler.BODY_CONTENTS.length());
            } else {
                this.resourcesAfterContents = body.substring(ResourceHandler.BODY_CONTENTS.length());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) - resourcesBeforeContents=" + this.resourcesBeforeContents));
            log.debug((Object)("parse(String) - resourcesAfterContents=" + this.resourcesAfterContents));
        }
    }

    protected String getStringInTag(String htmlContents, String startTag) {
        int startIndex = htmlContents.indexOf(startTag);
        if (startIndex != -1) {
            startIndex += startTag.length();
            String endTag = "</" + startTag.substring(1);
            int lastIndex = htmlContents.indexOf(endTag);
            if (lastIndex != -1) {
                return htmlContents.substring(startIndex, lastIndex);
            }
        }
        return null;
    }

    public void addResourcesToHead(RenderRequest request, RenderResponse response) {
        try {
            response.getWriter().write(this.resourcesInHead);
            response.getWriter().flush();
        }
        catch (IOException e) {
            log.error((Object)"cannot render resources before contents.", (Throwable)e);
        }
    }

    public void renderResourcesBeforeContents(RenderRequest request, RenderResponse response) {
        try {
            response.getWriter().write(this.resourcesBeforeContents);
            response.getWriter().flush();
        }
        catch (IOException e) {
            log.error((Object)"cannot render resources before contents.", (Throwable)e);
        }
    }

    public void renderResourcesAfterContents(RenderRequest request, RenderResponse response) {
        try {
            response.getWriter().write(this.resourcesAfterContents);
            response.getWriter().flush();
        }
        catch (IOException e) {
            log.error((Object)"cannot render resources after contents.", (Throwable)e);
        }
    }
}

