package jp.sf.pal.vfs.beans;

import jp.sf.pal.vfs.VFSConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.seasar.portlet.util.PortletConfigUtil;
import org.seasar.portlet.util.PortletRequestUtil;
import org.seasar.portlet.util.PortletResponseUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class HeaderMenuSessionBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(HeaderMenuSessionBean.class);

    public static final String LIST_VIEW_PAGE = "LIST_VIEW_PAGE";

    public static final String NEW_FILE_PAGE = "NEW_FILE_PAGE";

    public static final String NEW_FOLDER_PAGE = "NEW_FOLDER_PAGE";

    public static final String UPLOAD_FILE_PAGE = "UPLOAD_FILE_PAGE";

    public static final String OPEN_PARENT_PAGE = "OPEN_PARENT_PAGE";

    private String uri;

    private String pageName;

    private String selectedAction;

    private String outputHtml;

    public HeaderMenuSessionBean()
    {
        if (log.isDebugEnabled())
        {
            log.debug("HeaderMenuSessionBean() - start");
        }

        uri = PortletConfigUtil.getInitParameter(VFSConstants.DEFULT_URI);
        if (uri == null)
        {
            uri = "/";
        }

        if (log.isDebugEnabled())
        {
            log.debug("HeaderMenuSessionBean() - end");
        }
    }

    public String getCreateNewFileImage()
    {
        String path = PortletRequestUtil.getContextPath()
                + "/images/accessories-text-editor.png";
        return PortletResponseUtil.encodeURL(path);
    }

    public String getCreateNewFolderImage()
    {
        String path = PortletRequestUtil.getContextPath()
                + "/images/folder.png";
        return PortletResponseUtil.encodeURL(path);
    }

    public String getOpenParentImage()
    {
        String path = PortletRequestUtil.getContextPath() + "/images/go-up.png";
        return PortletResponseUtil.encodeURL(path);
    }

    public String getUploadFileImage()
    {
        String path = PortletRequestUtil.getContextPath()
                + "/images/document-save.png";
        return PortletResponseUtil.encodeURL(path);
    }

    public String getTrashImage()
    {
        String path = PortletRequestUtil.getContextPath()
                + "/images/user-trash.png";
        return PortletResponseUtil.encodeURL(path);
    }

    public String goToListViewPage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("goToListViewPage()");
        }

        setPageName(LIST_VIEW_PAGE);
        return LIST_VIEW_PAGE;
    }

    public String goToNewFilePage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("goToNewFilePage()");
        }

        setPageName(NEW_FILE_PAGE);
        return NEW_FILE_PAGE;
    }

    public String goToNewFolderPage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("goToNewFolderPage()");
        }

        setPageName(NEW_FOLDER_PAGE);
        return NEW_FOLDER_PAGE;
    }

    public String goToUploadFilePage()
    {
        setPageName(UPLOAD_FILE_PAGE);
        return UPLOAD_FILE_PAGE;
    }

    public String go()
    {
        if (log.isDebugEnabled())
        {
            log.debug("go()");
        }

        // update uri
        setPageName(LIST_VIEW_PAGE);
        return LIST_VIEW_PAGE;
    }

    public String openParent()
    {
        if (log.isDebugEnabled())
        {
            log.debug("openParent()");
        }

        try
        {
            FileSystemManager fsManager = VFS.getManager();
            FileObject currentDirectory = fsManager.resolveFile(getUri());
            FileObject parent = currentDirectory.getParent();
            if (parent != null)
            {
                setUri(parent.getName().getURI());
            }
            else
            {
                // TODO i18n
                FacesMessageUtil
                        .addWarnMessage("The parent folder does not exist.");
            }
        }
        catch (FileSystemException e)
        {
            // TODO i18n
            FacesMessageUtil.addErrorMessage(
                    "Failed to open the parent directory.", e.toString());
            log.error("Failed to open the parent directory.", e);
        }

        setPageName(LIST_VIEW_PAGE);
        return LIST_VIEW_PAGE;
    }

    /**
     * @return the uri
     */
    public String getUri()
    {
        return uri;
    }

    /**
     * @param uri the uri to set
     */
    public void setUri(String uri)
    {
        this.uri = uri;
    }

    /**
     * @return the pageName
     */
    public String getPageName()
    {
        return pageName;
    }

    /**
     * @param pageName the pageName to set
     */
    public void setPageName(String pageName)
    {
        this.pageName = pageName;
    }

    /**
     * @return the selectedAction
     */
    public String getSelectedAction()
    {
        return selectedAction;
    }

    /**
     * @param selectedAction the selectedAction to set
     */
    public void setSelectedAction(String selectedAction)
    {
        this.selectedAction = selectedAction;
    }

    /**
     * @return the outputHtml
     */
    public String getOutputHtml()
    {
        String buf = outputHtml;
        outputHtml = "";
        return buf;
    }

    /**
     * @param outputHtml the outputHtml to set
     */
    public void setOutputHtml(String outputHtml)
    {
        this.outputHtml = outputHtml;
    }

}
