<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

	<!-- MENU -->
	<f:subview id="header">
		<jsp:include flush="true" page="HeaderMenu.jsp" />
	</f:subview>

	<h:form>

		<!-- Table -->
		<h:dataTable id="fileList" border="1" var="item" width="100%"
			value="#{listViewPage.objects}" headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate">
			<h:column>
				<f:facet name="header">
					<h:outputText value="File Name" />
				</f:facet>
				<h:commandLink action="#{listViewPage.select}">
					<h:outputText id="name" value="#{item.baseName}" />
				</h:commandLink>
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Size" />
				</f:facet>
				<h:outputText id="size" value="#{item.formattedSize}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Content Type" />
				</f:facet>
				<h:outputText id="contentType" value="#{item.contentType}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Date" />
				</f:facet>
				<h:outputText id="date" value="#{item.formattedLastModifiedTime}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Action" />
				</f:facet>
				<h:commandButton type="submit" alt="Delete" title="Delete"
					image="#{headerMenuSession.trashImage}"
					action="#{listViewPage.delete}"
					onclick="if(!confirm('Do you want to delete this file/directory?')) return false;" />
			</h:column>
		</h:dataTable>

	</h:form>
</f:view>

