/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.tomahawk.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceHandlerImpl {
    public static final String BODY_CONTENTS = ResourceHandlerImpl.class.getName() + ".CONTENTS";
    public static final String HTML_CONTENTS = "<html><head></head><body>" + BODY_CONTENTS + "</body></html>";
    private static final String PROCESS_REQUEST_CHANGE_FOR_STYLE_FUNC = "processRequestChangeForStyle_";
    protected static final String ASYNC_REQUEST_VAR = "asyncRequest_";
    protected static final String LOAD_SCRIPT_FUNC = "loadMyFacesScript_";
    protected static final String LOAD_STYLE_FUNC = "loadMyFacesStyle_";
    protected static final String ADD_RESOURCES_TO_HEAD = "ADD_RESOURCES_TO_HEAD";
    protected static final String RENDER_RESOURCES_AFTER_CONTENTS = "RENDER_RESOURCES_AFTER_CONTENTS";
    protected static final String RENDER_RESOURCES_BEFORE_CONTENTS = "RENDER_RESOURCES_BEFORE_CONTENTS";
    private static final Log log = LogFactory.getLog((Class)ResourceHandlerImpl.class);
    protected String resourcesInHead = "";
    protected String resourcesBeforeContents = "";
    protected String resourcesAfterContents = "";

    public void parse(String htmlContents) {
        this.resourcesInHead = this.getStringInTag(htmlContents, "<head>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) - resourcesInHead=" + this.resourcesInHead));
        }
        if (this.resourcesInHead == null) {
            this.resourcesInHead = "";
        }
        String body = this.getStringInTag(htmlContents, "<body>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) - body=" + body));
        }
        if (body != null) {
            int startIndex = body.indexOf(BODY_CONTENTS);
            if (startIndex > 0) {
                this.resourcesBeforeContents = body.substring(0, startIndex);
                this.resourcesAfterContents = body.substring(startIndex + BODY_CONTENTS.length());
            } else {
                this.resourcesAfterContents = body.substring(BODY_CONTENTS.length());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse(String) - resourcesBeforeContents=" + this.resourcesBeforeContents));
            log.debug((Object)("parse(String) - resourcesAfterContents=" + this.resourcesAfterContents));
        }
    }

    protected String getStringInTag(String htmlContents, String startTag) {
        int startIndex = htmlContents.indexOf(startTag);
        if (startIndex != -1) {
            startIndex += startTag.length();
            String endTag = "</" + startTag.substring(1);
            int lastIndex = htmlContents.indexOf(endTag);
            if (lastIndex != -1) {
                return htmlContents.substring(startIndex, lastIndex);
            }
        }
        return null;
    }

    public void addResourcesToHead(RenderRequest request, RenderResponse response) {
        if (this.resourcesInHead != null && !this.resourcesInHead.equals("")) {
            try {
                this.writeResources(response, this.resourcesInHead, ADD_RESOURCES_TO_HEAD);
                response.getWriter().flush();
            }
            catch (IOException e) {
                log.error((Object)"cannot render resources before contents.", (Throwable)e);
            }
        }
    }

    public void renderResourcesBeforeContents(RenderRequest request, RenderResponse response) {
        if (this.resourcesBeforeContents != null && !this.resourcesBeforeContents.equals("")) {
            try {
                this.writeResources(response, this.resourcesBeforeContents, RENDER_RESOURCES_BEFORE_CONTENTS);
                response.getWriter().flush();
            }
            catch (IOException e) {
                log.error((Object)"cannot render resources before contents.", (Throwable)e);
            }
        }
    }

    public void renderResourcesAfterContents(RenderRequest request, RenderResponse response) {
        if (this.resourcesAfterContents != null && !this.resourcesAfterContents.equals("")) {
            try {
                this.writeResources(response, this.resourcesAfterContents, RENDER_RESOURCES_AFTER_CONTENTS);
                response.getWriter().flush();
            }
            catch (IOException e) {
                log.error((Object)"cannot render resources after contents.", (Throwable)e);
            }
        }
    }

    public void renderBeforeContents(RenderResponse response) {
        String asyncRequestVar = ASYNC_REQUEST_VAR + response.getNamespace();
        String loadStyleFunction = LOAD_STYLE_FUNC + response.getNamespace();
        String processRequestChangeForStyleFunction = PROCESS_REQUEST_CHANGE_FOR_STYLE_FUNC + response.getNamespace();
        String fixPathsInCssTextFunction = "fixPathsInCssText_" + response.getNamespace();
        String replaceURIFunction = "replaceURI_" + response.getNamespace();
        String createURIFunction = "createURI_" + response.getNamespace();
        try {
            PrintWriter writer = response.getWriter();
            writer.write("<script type=\"text/javascript\">\n");
            writer.write("<!--\n");
            writer.write("\n");
            writer.write("function " + loadStyleFunction + "(updateURL){" + "\n");
            writer.write("    var " + asyncRequestVar + ";" + "\n");
            writer.write("    var baseURI=updateURL.substring(0, updateURL.lastIndexOf('/') + 1);\n");
            writer.write("    if (window.XMLHttpRequest) {\n");
            writer.write("        " + asyncRequestVar + " = new XMLHttpRequest();" + "\n");
            writer.write("    } else if (window.ActiveXObject) {\n");
            writer.write("        " + asyncRequestVar + " = new ActiveXObject(\"Microsoft.XMLHTTP\");" + "\n");
            writer.write("    }\n");
            writer.write("    " + asyncRequestVar + ".onreadystatechange = " + processRequestChangeForStyleFunction + ";" + "\n");
            writer.write("\n");
            writer.write("    function " + processRequestChangeForStyleFunction + "() {" + "\n");
            writer.write("        if (" + asyncRequestVar + ".readyState == 4) {" + "\n");
            writer.write("            if (" + asyncRequestVar + ".status == 200) {" + "\n");
            writer.write("                var headNode = document.getElementsByTagName(\"head\")[0];\n");
            writer.write("                if(headNode)\n");
            writer.write("                {\n");
            writer.write("                    var styleNode = document.createElement(\"style\");\n");
            writer.write("                    styleNode.setAttribute(\"type\", \"text/css\");\n");
            writer.write("                    var styleContent = " + asyncRequestVar + ".responseText;" + "\n");
            writer.write("                    styleContent = " + fixPathsInCssTextFunction + "(styleContent, baseURI);" + "\n");
            writer.write("                    if(styleNode.styleSheet)// IE\n");
            writer.write("                    {\n");
            writer.write("                        styleNode.styleSheet.cssText = styleContent;\n");
            writer.write("                    }\n");
            writer.write("                    else\n");
            writer.write("                    {//w3c\n");
            writer.write("                        var cssText = document.createTextNode(styleContent);\n");
            writer.write("                        styleNode.appendChild(cssText);\n");
            writer.write("                    }\n");
            writer.write("                    headNode.appendChild(styleNode);\n");
            writer.write("                }\n");
            writer.write("                return;\n");
            writer.write("            }\n");
            writer.write("            else\n");
            writer.write("            {\n");
            writer.write("                window.alert(\"An error occurs on loading style. STATUS=\" + " + asyncRequestVar + ".status);" + "\n");
            writer.write("            }\n");
            writer.write("        }\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("    " + asyncRequestVar + ".open(\"GET\", updateURL, true);" + "\n");
            writer.write("    " + asyncRequestVar + ".send(null);" + "\n");
            writer.write("}\n");
            writer.write("function " + fixPathsInCssTextFunction + "(cssStr, URI){" + "\n");
            writer.write("    if(!cssStr || !URI){ return; }\n");
            writer.write("    var pos = 0; var str = \"\"; var url = \"\";\n");
            writer.write("    while(pos!=-1){\n");
            writer.write("        pos = 0;url = \"\";\n");
            writer.write("        pos = cssStr.indexOf(\"url(\", pos);\n");
            writer.write("        if(pos<0){ break; }\n");
            writer.write("        str += cssStr.slice(0,pos+4);\n");
            writer.write("        cssStr = cssStr.substring(pos+4, cssStr.length);\n");
            writer.write("        url += cssStr.match(/^[\\t\\s\\w()\\/.\\\\\\'\\\"-:#=&?]*\\)/)[0]; // url string\n");
            writer.write("        cssStr = cssStr.substring(url.length-1, cssStr.length); // remove url from css string til next loop\n");
            writer.write("        url = url.replace(/^[\\s\\t]*([\\'\\\"]?)([\\w()\\/.\\\\\\'\\\"-:#=&?]*)\\1[\\s\\t]*?\\)/,\"$2\"); // clean string\n");
            writer.write("        if(url.search(/(file|https?|ftps?):\\/\\//)==-1){\n");
            writer.write("            url = " + replaceURIFunction + "(URI,url);" + "\n");
            writer.write("        }\n");
            writer.write("        str += url;\n");
            writer.write("    };\n");
            writer.write("    return str+cssStr;\n");
            writer.write("}\n");
            writer.write("function " + replaceURIFunction + "(uri, relUri) {" + "\n");
            writer.write("    // TODO: support for IPv6, see RFC 2732\n");
            writer.write("\n");
            writer.write("    var relobj = " + createURIFunction + "(relUri);" + "\n");
            writer.write("    var uriobj = " + createURIFunction + "(uri);" + "\n");
            writer.write("\n");
            writer.write("    if (relobj.path == \"\" && relobj.scheme == null && relobj.authority == null && relobj.query == null) {\n");
            writer.write("        if (relobj.fragment != null) {\n");
            writer.write("            uriobj.fragment = relobj.fragment; \n");
            writer.write("        }\n");
            writer.write("        relobj = uriobj;\n");
            writer.write("    }\n");
            writer.write("    else if (relobj.scheme == null) {\n");
            writer.write("        relobj.scheme = uriobj.scheme;\n");
            writer.write("\n");
            writer.write("        if (relobj.authority == null) {\n");
            writer.write("            relobj.authority = uriobj.authority;\n");
            writer.write("\n");
            writer.write("            if (relobj.path.charAt(0) != \"/\") {\n");
            writer.write("                var path = uriobj.path.substring(0, uriobj.path.lastIndexOf(\"/\") + 1) + relobj.path;\n");
            writer.write("\n");
            writer.write("                var segs = path.split(\"/\");\n");
            writer.write("                for (var j = 0; j < segs.length; j++) {\n");
            writer.write("                    if (segs[j] == \".\") {\n");
            writer.write("                        if (j == segs.length - 1) {\n");
            writer.write("                            segs[j] = \"\"; \n");
            writer.write("                        } else {\n");
            writer.write("                            segs.splice(j, 1);\n");
            writer.write("                            j--;\n");
            writer.write("                        }\n");
            writer.write("                    } else if (j > 0 && !(j == 1 && segs[0] == \"\") && segs[j] == \"..\" && segs[j-1] != \"..\") {\n");
            writer.write("                        if (j == segs.length - 1) {\n");
            writer.write("                            segs.splice(j, 1);\n");
            writer.write("                            segs[j - 1] = \"\";\n");
            writer.write("                        } else {\n");
            writer.write("                            segs.splice(j - 1, 2);\n");
            writer.write("                            j -= 2; \n");
            writer.write("                        }\n");
            writer.write("                    }\n");
            writer.write("                }\n");
            writer.write("                relobj.path = segs.join(\"/\");\n");
            writer.write("            }\n");
            writer.write("        }\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("    uri = \"\";\n");
            writer.write("    if (relobj.scheme != null) {\n");
            writer.write("        uri += relobj.scheme + \":\"; \n");
            writer.write("    }\n");
            writer.write("    if (relobj.authority != null) {\n");
            writer.write("        uri += \"//\" + relobj.authority;\n");
            writer.write("    }\n");
            writer.write("    uri += relobj.path;\n");
            writer.write("    if (relobj.query != null) {\n");
            writer.write("        uri += \"?\" + relobj.query;\n");
            writer.write("    }\n");
            writer.write("    if (relobj.fragment != null) {\n");
            writer.write("        uri += \"#\" + relobj.fragment;\n");
            writer.write("    }\n");
            writer.write("   \n");
            writer.write("    return uri;\n");
            writer.write("}\n");
            writer.write("\n");
            writer.write("function " + createURIFunction + "(uri)" + "\n");
            writer.write("{\n");
            writer.write("    var uriObj = new Object();\n");
            writer.write("\n");
            writer.write("    // break the uri into its main components\n");
            writer.write("    var regexp = \"^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\\\?([^#]*))?(#(.*))?$\";\n");
            writer.write("    var r = uri.match(new RegExp(regexp));\n");
            writer.write("\n");
            writer.write("    uriObj.scheme = r[2] || (r[1] ? \"\" : null);\n");
            writer.write("    uriObj.authority = r[4] || (r[3] ? \"\" : null);\n");
            writer.write("    uriObj.path = r[5]; // can never be undefined\n");
            writer.write("    uriObj.query = r[7] || (r[6] ? \"\" : null);\n");
            writer.write("    uriObj.fragment  = r[9] || (r[8] ? \"\" : null);\n");
            writer.write("\n");
            writer.write("    if (uriObj.authority != null) {\n");
            writer.write("        // server based naming authority\n");
            writer.write("        regexp = \"^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$\";\n");
            writer.write("        r = uriObj.authority.match(new RegExp(regexp));\n");
            writer.write("\n");
            writer.write("        uriObj.user = r[3] || null;\n");
            writer.write("        uriObj.password = r[4] || null;\n");
            writer.write("        uriObj.host = r[5];\n");
            writer.write("        uriObj.port = r[7] || null;\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("    return uriObj;\n");
            writer.write("}\n");
            writer.write("\n");
            writer.write("-->\n");
            writer.write("</script>\n");
            writer.flush();
        }
        catch (IOException e) {
            log.error((Object)"cannot write javascript functions.", (Throwable)e);
        }
    }

    protected void writeResources(RenderResponse response, String contents, String status) throws IOException {
        StringBuffer sb = new StringBuffer();
        Pattern linkPattern = Pattern.compile("<link ([^>]*rel=['\"]?stylesheet['\"]?[^>]*)>");
        Matcher linkMatcher = linkPattern.matcher(contents);
        ArrayList<String> remoteStyles = new ArrayList<String>();
        while (linkMatcher.find()) {
            Pattern hrefPattern;
            Matcher hrefMatcher;
            linkMatcher.appendReplacement(sb, "");
            String str1 = linkMatcher.group(1);
            if (str1 == null || !(hrefMatcher = (hrefPattern = Pattern.compile("href=['\"]?([^'\">]*)")).matcher(str1)).find() || hrefMatcher.group(1) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("writeResources(RenderResponse, String, int) hrefMatcher.group(1)=" + hrefMatcher.group(1)));
            }
            remoteStyles.add(hrefMatcher.group(1));
        }
        linkMatcher.appendTail(sb);
        contents = sb.toString();
        String loadStyleFunction = LOAD_STYLE_FUNC + response.getNamespace();
        PrintWriter writer = response.getWriter();
        writer.write("<!-- BEGIN: " + status + " -->\n");
        writer.write("<script type=\"text/javascript\">\n");
        writer.write("<!--\n");
        Iterator ite = remoteStyles.iterator();
        while (ite.hasNext()) {
            String remoteStyle = (String)ite.next();
            writer.write(loadStyleFunction + "(\"" + remoteStyle + "\");");
            writer.write("\n");
        }
        writer.write("-->\n");
        writer.write("</script>\n");
        writer.write(contents);
        writer.write("<!-- END: " + status + " -->\n");
    }
}

