package jp.sf.pal.vfs.beans;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;

import javax.faces.context.FacesContext;

import jp.sf.pal.vfs.VFSConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class NewFileContentPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(NewFileContentPageBean.class);

    private HeaderMenuSessionBean headerMenuSession;

    private String text;

    public String create()
    {
        if (log.isDebugEnabled())
        {
            log.debug("create() text=" + getText());
        }

        try
        {
            FileSystemManager fsManager = VFS.getManager();
            FileObject newFileObject = fsManager
                    .resolveFile(getHeaderMenuSession().getUri() + "/"
                            + getNewFile());

            // TODO add confirmation
            // if (!newFileObject.exists())
            // {
            // TODO should catch exception to check if it's created
            newFileObject.createFile();
            Writer writer = null;
            try
            {
                writer = new OutputStreamWriter(newFileObject.getContent()
                        .getOutputStream(), "UTF-8");
                writer.write(getText());
                writer.flush();
            }
            catch (UnsupportedEncodingException e)
            {
                log.warn("Wrong encoding.");
                // TODO I18N
                FacesMessageUtil.addWarnMessage("Wrong encoding.");
            }
            catch (IOException e)
            {
                log.warn("Cannot write the content.");
                // TODO I18N
                FacesMessageUtil.addWarnMessage("Cannot write the content.");
            }
            finally
            {
                if (writer != null)
                {
                    try
                    {
                        writer.close();
                    }
                    catch (IOException e)
                    {
                    }
                }
            }

            // TODO I18N
            FacesMessageUtil
                    .addInfoMessage("Created new file: " + getNewFile());
            return getHeaderMenuSession().goToListViewPage();
            // }
        }
        catch (FileSystemException e)
        {
            // TODO I18N
            FacesMessageUtil.addInfoMessage("Failed to create the new file: "
                    + getNewFile(), e.toString());
            log.error("Failed to create the new file: " + getNewFile(), e);
        }
        return null;
    }

    /**
     * @return the headerMenuSession
     */
    public HeaderMenuSessionBean getHeaderMenuSession()
    {
        return headerMenuSession;
    }

    /**
     * @param headerMenuSession the headerMenuSession to set
     */
    public void setHeaderMenuSession(HeaderMenuSessionBean headerMenuSession)
    {
        this.headerMenuSession = headerMenuSession;
    }

    /**
     * @return Returns the newFile.
     */
    public String getNewFile()
    {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap();
        return (String) sessionMap.get(VFSConstants.NEW_FILE_CONTENT_FILE_NAME);
    }

    /**
     * @return the type
     */
    public String getType()
    {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap();
        return (String) sessionMap.get(VFSConstants.NEW_FILE_CONTENT_FILE_TYPE);
    }

    /**
     * @return the text
     */
    public String getText()
    {
        return text;
    }

    /**
     * @param text the text to set
     */
    public void setText(String text)
    {
        this.text = text;
    }
}
