/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.beans;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class UploadFilePageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(UploadFilePageBean.class);

    private static final int BLOCK_SIZE = 4096;

    private HeaderMenuSessionBean headerMenuSession;

    private UploadedFile uploadedFile;

    public String upload()
    {
        if (log.isDebugEnabled())
        {
            log.debug("upload() - start");
            log.debug("upload() - upload: getUploadedFile()="
                    + getUploadedFile());
            log.debug("upload() - upload: filename="
                    + getUploadedFile().getName());
        }
        try
        {
            // For Windows
            String filename = getUploadedFile().getName();
            int index = filename.lastIndexOf("\\");
            if (index > 0)
            {
                filename = filename.substring(index + 1);
            }
            if (log.isDebugEnabled())
            {
                log.debug("upload() - filename=" + filename);
            }

            FileSystemManager fsManager = VFS.getManager();
            FileObject newFileObject = fsManager
                    .resolveFile(getHeaderMenuSession().getUri() + "/"
                            + filename);
            // TODO add confirmation
            if (newFileObject.exists())
            {
                // TODO I18N
                FacesMessageUtil
                        .addWarnMessage(filename
                                + " exists. You need to delete it before uploading it. ");
                return headerMenuSession.goToListViewPage();
            }
            // TODO should catch exception to check if it's created
            newFileObject.createFile();
            newFileObject.getContent().close();
            drain(getUploadedFile().getInputStream(), newFileObject
                    .getContent().getOutputStream());

            // TODO I18N
            FacesMessageUtil.addInfoMessage("Uploaded file: " + filename);

            setUploadedFile(null);

            if (log.isDebugEnabled())
            {
                log.debug("upload() - end");
            }
            return headerMenuSession.goToListViewPage();
        }
        catch (FileSystemException e)
        {
            // TODO I18N
            FacesMessageUtil.addErrorMessage("Failed to update the file.", e
                    .toString());
            log.error("Failed to update the file.", e);
        }
        catch (IOException e)
        {
            // TODO I18N
            FacesMessageUtil.addErrorMessage("Failed to update the file.", e
                    .toString());
            log.error("Failed to update the file.", e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("upload() - end");
        }
        return null;
    }

    private void drain(InputStream r, OutputStream w) throws IOException
    {
        byte[] bytes = new byte[BLOCK_SIZE];
        try
        {
            int length = r.read(bytes);
            while (length != -1)
            {
                if (length != 0)
                {
                    w.write(bytes, 0, length);
                    w.flush();
                }
                length = r.read(bytes);
            }
        }
        finally
        {
            bytes = null;
        }
    }

    /**
     * @return Returns the uploadedFile.
     */
    public UploadedFile getUploadedFile()
    {
        return uploadedFile;
    }

    /**
     * @param uploadedFile The uploadedFile to set.
     */
    public void setUploadedFile(UploadedFile uploadedFile)
    {
        this.uploadedFile = uploadedFile;
    }

    /**
     * @return the headerMenuSession
     */
    public HeaderMenuSessionBean getHeaderMenuSession()
    {
        return headerMenuSession;
    }

    /**
     * @param headerMenuSession the headerMenuSession to set
     */
    public void setHeaderMenuSession(HeaderMenuSessionBean headerMenuSession)
    {
        this.headerMenuSession = headerMenuSession;
    }
}
