<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

	<!-- MENU -->
	<f:subview id="header">
		<jsp:include flush="true" page="HeaderMenu.jsp" />
	</f:subview>


	<h:form>
		<t:htmlTag value="div">
			<h:panelGrid columns="3">
				<h:outputText value="File Name:" styleClass="portlet-form-field" />
				<h:outputText value="#{newFileContentPage.newFile}"
					styleClass="portlet-form-field" />
				<h:commandButton value="Create New File"
					action="#{newFileContentPage.create}"
					styleClass="portlet-form-button" />
			</h:panelGrid>
		</t:htmlTag>

		<t:htmlTag value="div" rendered="#{newFileContentPage.type == 'TEXT'}">
			<h:inputTextarea value="#{newFileContentPage.text}"
				style="height: 400px; width: 100%" />
		</t:htmlTag>

		<t:htmlTag value="div" rendered="#{newFileContentPage.type == 'HTML'}">
			<t:inputHtml value="#{newFileContentPage.text}"
				style="height: 400px; width: 100%" allowEditSource="true"
				showPropertiesToolBox="true" showLinksToolBox="true"
				showImagesToolBox="true" showTablesToolBox="true"
				showCleanupExpressionsToolBox="true" showDebugToolBox="false" />
		</t:htmlTag>

	</h:form>

</f:view>

