/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.dao;

import java.util.List;

import jp.sf.pal.addresslist.model.Postal;

public interface PostalDao
{
    public Class BEAN = Postal.class;

    //add, update, delete
    public void save(Postal postal);

    public void delete(Postal postal);

    public void update(Postal postal);

    public void saveOrUpdate(Postal postal);

    // By id
    public String getPostalById_ARGS = "id";

    public Postal getPostalById(long id);

    // All BlogMessage
    public List getAllPostal();

}
