<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle
		basename="jp.sf.pal.addresslist.resources.AddressListResources"
		var="msgs" />

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<t:div styleClass="portlet-section-header">
			<h:outputText value="#{msgs['addresslistedit.BasicInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="familyname">
				<h:outputText value="#{msgs['addresslistedit.FamilyName']}" />
			</h:outputLabel>
			<h:inputText id="familyname"
				value="#{addressListEditPage.familyname}" maxlength="128" />
			<h:message for="familyname"></h:message>

			<h:outputLabel for="givenname">
				<h:outputText value="#{msgs['addresslistedit.GivenName']}" />
			</h:outputLabel>
			<h:inputText id="givenname" value="#{addressListEditPage.givenname}"
				maxlength="128" />
			<h:message for="givenname"></h:message>

			<h:outputLabel for="middlename">
				<h:outputText value="#{msgs['addresslistedit.MiddleName']}" />
			</h:outputLabel>
			<h:inputText id="middlename"
				value="#{addressListEditPage.middlename}" maxlength="64" />
			<h:message for="middlename"></h:message>

			<h:outputLabel for="nameprefix">
				<h:outputText value="#{msgs['addresslistedit.NamePrefix']}" />
			</h:outputLabel>
			<h:inputText id="nameprefix"
				value="#{addressListEditPage.nameprefix}" maxlength="32" />
			<h:message for="nameprefix"></h:message>

			<h:outputLabel for="namesuffix">
				<h:outputText value="#{msgs['addresslistedit.NameSuffix']}" />
			</h:outputLabel>
			<h:inputText id="namesuffix"
				value="#{addressListEditPage.namesuffix}" maxlength="32" />
			<h:message for="namesuffix"></h:message>

			<h:outputLabel for="nickname">
				<h:outputText value="#{msgs['addresslistedit.Nickname']}" />
			</h:outputLabel>
			<h:inputText id="nickname" value="#{addressListEditPage.nickname}"
				maxlength="64" />
			<h:message for="nickname"></h:message>

		</h:panelGrid>

		<t:div styleClass="portlet-section-header">
			<h:outputText value="#{msgs['addresslistedit.PersonalInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="bdate">
				<h:outputText value="#{msgs['addresslistedit.Bdate']}" />
			</h:outputLabel>
			<t:inputCalendar id="bdate" value="#{addressListEditPage.bdate}"
				renderAsPopup="true" popupTodayString="Today" popupWeekString="Wk"
				popupDateFormat="yyyy-MM-dd" renderPopupButtonAsImage="true" />
			<h:message for="bdate"></h:message>

			<h:outputLabel for="gender">
				<h:outputText value="#{msgs['addresslistedit.Gender']}" />
			</h:outputLabel>
			<h:selectOneMenu id="gender" value="#{addressListEditPage.gender}">
				<f:selectItems value="#{addressListEditPage.genderItems}" />
			</h:selectOneMenu>
			<h:message for="gender"></h:message>

			<h:outputLabel for="employer">
				<h:outputText value="#{msgs['addresslistedit.Employer']}" />
			</h:outputLabel>
			<h:inputText id="employer" value="#{addressListEditPage.employer}"
				maxlength="128" />
			<h:message for="employer"></h:message>

			<h:outputLabel for="department">
				<h:outputText value="#{msgs['addresslistedit.Department']}" />
			</h:outputLabel>
			<h:inputText id="department"
				value="#{addressListEditPage.department}" maxlength="128" />
			<h:message for="department"></h:message>

			<h:outputLabel for="jobtitle">
				<h:outputText value="#{msgs['addresslistedit.Jobtitle']}" />
			</h:outputLabel>
			<h:inputText id="jobtitle" value="#{addressListEditPage.jobtitle}"
				maxlength="64" />
			<h:message for="jobtitle"></h:message>

		</h:panelGrid>

		<t:div styleClass="portlet-section-header">
			<h:outputText
				value="#{msgs['addresslistedit.HomeAddressInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="homeCountry">
				<h:outputText value="#{msgs['addresslistedit.Country']}" />
			</h:outputLabel>
			<h:inputText id="homeCountry"
				value="#{addressListEditPage.homeCountry}" maxlength="128" />
			<h:message for="homeCountry"></h:message>

			<h:outputLabel for="homePostalcode">
				<h:outputText value="#{msgs['addresslistedit.PostalCode']}" />
			</h:outputLabel>
			<h:inputText id="homePostalcode"
				value="#{addressListEditPage.homePostalcode}" maxlength="255" />
			<h:message for="homePostalcode"></h:message>

			<h:outputLabel for="homeStateprov">
				<h:outputText value="#{msgs['addresslistedit.StateProv']}" />
			</h:outputLabel>
			<h:inputText id="homeStateprov"
				value="#{addressListEditPage.homeStateprov}" maxlength="64" />
			<h:message for="homeStateprov"></h:message>

			<h:outputLabel for="homeCity">
				<h:outputText value="#{msgs['addresslistedit.City']}" />
			</h:outputLabel>
			<h:inputText id="homeCity" value="#{addressListEditPage.homeCity}"
				maxlength="64" />
			<h:message for="homeCity"></h:message>

			<h:outputLabel for="homeStreet">
				<h:outputText value="#{msgs['addresslistedit.Street']}" />
			</h:outputLabel>
			<h:inputText id="homeStreet"
				value="#{addressListEditPage.homeStreet}" maxlength="64" />
			<h:message for="homeStreet"></h:message>

			<h:outputLabel for="homeName">
				<h:outputText value="#{msgs['addresslistedit.Name']}" />
			</h:outputLabel>
			<h:inputText id="homeName" value="#{addressListEditPage.homeName}"
				maxlength="128" />
			<h:message for="homeName"></h:message>

			<h:outputLabel for="homeOrganization">
				<h:outputText value="#{msgs['addresslistedit.Organization']}" />
			</h:outputLabel>
			<h:inputText id="homeOrganization"
				value="#{addressListEditPage.homeOrganization}" maxlength="255" />
			<h:message for="homeOrganization"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="homeTelephone">
				<h:outputText value="#{msgs['addresslistedit.Telephone']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homeTelephone">
				<h:outputText value="+" />
				<h:inputText id="homeTelephoneIntcode"
					value="#{addressListEditPage.homeTelephoneIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homeTelephoneLoccode"
					value="#{addressListEditPage.homeTelephoneLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homeTelephoneNumber"
					value="#{addressListEditPage.homeTelephoneNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homeTelephoneExt"
					value="#{addressListEditPage.homeTelephoneExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homeTelephone"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistedit.HomeTelephoneExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homeTelephoneComment">
				<h:outputText value="#{msgs['addresslistedit.TelephoneComment']}" />
			</h:outputLabel>
			<h:inputText id="homeTelephoneComment"
				value="#{addressListEditPage.homeTelephoneComment}" maxlength="255" />
			<h:message for="homeTelephoneComment"></h:message>

			<h:outputLabel for="homeFax">
				<h:outputText value="#{msgs['addresslistedit.Fax']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homeFax">
				<h:outputText value="+" />
				<h:inputText id="homeFaxIntcode"
					value="#{addressListEditPage.homeFaxIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homeFaxLoccode"
					value="#{addressListEditPage.homeFaxLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homeFaxNumber"
					value="#{addressListEditPage.homeFaxNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homeFaxExt"
					value="#{addressListEditPage.homeFaxExt}" maxlength="32" size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homeFax"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistedit.HomeFaxExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homeFaxComment">
				<h:outputText value="#{msgs['addresslistedit.FaxComment']}" />
			</h:outputLabel>
			<h:inputText id="homeFaxComment"
				value="#{addressListEditPage.homeFaxComment}" maxlength="255" />
			<h:message for="homeFaxComment"></h:message>

			<h:outputLabel for="homeMobile">
				<h:outputText value="#{msgs['addresslistedit.Mobile']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homeMobile">
				<h:outputText value="+" />
				<h:inputText id="homeMobileIntcode"
					value="#{addressListEditPage.homeMobileIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homeMobileLoccode"
					value="#{addressListEditPage.homeMobileLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homeMobileNumber"
					value="#{addressListEditPage.homeMobileNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homeMobileExt"
					value="#{addressListEditPage.homeMobileExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homeMobile"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistedit.HomeMobileExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homeMobileComment">
				<h:outputText value="#{msgs['addresslistedit.MobileComment']}" />
			</h:outputLabel>
			<h:inputText id="homeMobileComment"
				value="#{addressListEditPage.homeMobileComment}" maxlength="255" />
			<h:message for="homeMobileComment"></h:message>

			<h:outputLabel for="homePager">
				<h:outputText value="#{msgs['addresslistedit.Pager']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homePager">
				<h:outputText value="+" />
				<h:inputText id="homePagerIntcode"
					value="#{addressListEditPage.homePagerIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homePagerLoccode"
					value="#{addressListEditPage.homePagerLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homePagerNumber"
					value="#{addressListEditPage.homePagerNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homePagerExt"
					value="#{addressListEditPage.homePagerExt}" maxlength="32" size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homePager"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistedit.HomePagerExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homePagerComment">
				<h:outputText value="#{msgs['addresslistedit.PagerComment']}" />
			</h:outputLabel>
			<h:inputText id="homePagerComment"
				value="#{addressListEditPage.homePagerComment}" maxlength="255" />
			<h:message for="homePagerComment"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="homeEmail1">
				<h:outputText value="#{msgs['addresslistedit.Email1']}" />
			</h:outputLabel>
			<h:inputText id="homeEmail1"
				value="#{addressListEditPage.homeEmail1}" maxlength="255" />
			<h:message for="homeEmail1"></h:message>

			<h:outputLabel for="homeEmail2">
				<h:outputText value="#{msgs['addresslistedit.Email2']}" />
			</h:outputLabel>
			<h:inputText id="homeEmail2"
				value="#{addressListEditPage.homeEmail2}" maxlength="255" />
			<h:message for="homeEmail2"></h:message>

			<h:outputLabel for="homeEmail3">
				<h:outputText value="#{msgs['addresslistedit.Email3']}" />
			</h:outputLabel>
			<h:inputText id="homeEmail3"
				value="#{addressListEditPage.homeEmail3}" maxlength="255" />
			<h:message for="homeEmail3"></h:message>

			<h:outputLabel for="homeUrl1">
				<h:outputText value="#{msgs['addresslistedit.Url1']}" />
			</h:outputLabel>
			<h:inputText id="homeUrl1" value="#{addressListEditPage.homeUrl1}"
				maxlength="255" />
			<h:message for="homeUrl1"></h:message>

			<h:outputLabel for="homeUrl2">
				<h:outputText value="#{msgs['addresslistedit.Url2']}" />
			</h:outputLabel>
			<h:inputText id="homeUrl2" value="#{addressListEditPage.homeUrl2}"
				maxlength="255" />
			<h:message for="homeUrl2"></h:message>

			<h:outputLabel for="homeUrl3">
				<h:outputText value="#{msgs['addresslistedit.Url3']}" />
			</h:outputLabel>
			<h:inputText id="homeUrl3" value="#{addressListEditPage.homeUrl3}"
				maxlength="255" />
			<h:message for="homeUrl3"></h:message>

		</h:panelGrid>


		<t:div styleClass="portlet-section-header">
			<h:outputText
				value="#{msgs['addresslistedit.BusinessAddressInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="businessCountry">
				<h:outputText value="#{msgs['addresslistedit.Country']}" />
			</h:outputLabel>
			<h:inputText id="businessCountry"
				value="#{addressListEditPage.businessCountry}" maxlength="128" />
			<h:message for="businessCountry"></h:message>

			<h:outputLabel for="businessPostalcode">
				<h:outputText value="#{msgs['addresslistedit.PostalCode']}" />
			</h:outputLabel>
			<h:inputText id="businessPostalcode"
				value="#{addressListEditPage.businessPostalcode}" maxlength="255" />
			<h:message for="businessPostalcode"></h:message>

			<h:outputLabel for="businessStateprov">
				<h:outputText value="#{msgs['addresslistedit.StateProv']}" />
			</h:outputLabel>
			<h:inputText id="businessStateprov"
				value="#{addressListEditPage.businessStateprov}" maxlength="64" />
			<h:message for="businessStateprov"></h:message>

			<h:outputLabel for="businessCity">
				<h:outputText value="#{msgs['addresslistedit.City']}" />
			</h:outputLabel>
			<h:inputText id="businessCity"
				value="#{addressListEditPage.businessCity}" maxlength="64" />
			<h:message for="businessCity"></h:message>

			<h:outputLabel for="businessStreet">
				<h:outputText value="#{msgs['addresslistedit.Street']}" />
			</h:outputLabel>
			<h:inputText id="businessStreet"
				value="#{addressListEditPage.businessStreet}" maxlength="64" />
			<h:message for="businessStreet"></h:message>

			<h:outputLabel for="businessName">
				<h:outputText value="#{msgs['addresslistedit.Name']}" />
			</h:outputLabel>
			<h:inputText id="businessName"
				value="#{addressListEditPage.businessName}" maxlength="128" />
			<h:message for="businessName"></h:message>

			<h:outputLabel for="businessOrganization">
				<h:outputText value="#{msgs['addresslistedit.Organization']}" />
			</h:outputLabel>
			<h:inputText id="businessOrganization"
				value="#{addressListEditPage.businessOrganization}" maxlength="255" />
			<h:message for="businessOrganization"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="businessTelephone">
				<h:outputText value="#{msgs['addresslistedit.Telephone']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessTelephone">
				<h:outputText value="+" />
				<h:inputText id="businessTelephoneIntcode"
					value="#{addressListEditPage.businessTelephoneIntcode}"
					maxlength="2" size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessTelephoneLoccode"
					value="#{addressListEditPage.businessTelephoneLoccode}"
					maxlength="32" size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessTelephoneNumber"
					value="#{addressListEditPage.businessTelephoneNumber}"
					maxlength="32" size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessTelephoneExt"
					value="#{addressListEditPage.businessTelephoneExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessTelephone"></h:message>

			<h:outputText value="" />
			<h:outputText
				value="#{msgs['addresslistedit.BusinessTelephoneExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessTelephoneComment">
				<h:outputText value="#{msgs['addresslistedit.TelephoneComment']}" />
			</h:outputLabel>
			<h:inputText id="businessTelephoneComment"
				value="#{addressListEditPage.businessTelephoneComment}"
				maxlength="255" />
			<h:message for="businessTelephoneComment"></h:message>

			<h:outputLabel for="businessFax">
				<h:outputText value="#{msgs['addresslistedit.Fax']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessFax">
				<h:outputText value="+" />
				<h:inputText id="businessFaxIntcode"
					value="#{addressListEditPage.businessFaxIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessFaxLoccode"
					value="#{addressListEditPage.businessFaxLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessFaxNumber"
					value="#{addressListEditPage.businessFaxNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessFaxExt"
					value="#{addressListEditPage.businessFaxExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessFax"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistedit.BusinessFaxExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessFaxComment">
				<h:outputText value="#{msgs['addresslistedit.FaxComment']}" />
			</h:outputLabel>
			<h:inputText id="businessFaxComment"
				value="#{addressListEditPage.businessFaxComment}" maxlength="255" />
			<h:message for="businessFaxComment"></h:message>

			<h:outputLabel for="businessMobile">
				<h:outputText value="#{msgs['addresslistedit.Mobile']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessMobile">
				<h:outputText value="+" />
				<h:inputText id="businessMobileIntcode"
					value="#{addressListEditPage.businessMobileIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessMobileLoccode"
					value="#{addressListEditPage.businessMobileLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessMobileNumber"
					value="#{addressListEditPage.businessMobileNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessMobileExt"
					value="#{addressListEditPage.businessMobileExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessMobile"></h:message>

			<h:outputText value="" />
			<h:outputText
				value="#{msgs['addresslistedit.BusinessMobileExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessMobileComment">
				<h:outputText value="#{msgs['addresslistedit.MobileComment']}" />
			</h:outputLabel>
			<h:inputText id="businessMobileComment"
				value="#{addressListEditPage.businessMobileComment}" maxlength="255" />
			<h:message for="businessMobileComment"></h:message>

			<h:outputLabel for="businessPager">
				<h:outputText value="#{msgs['addresslistedit.Pager']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessPager">
				<h:outputText value="+" />
				<h:inputText id="businessPagerIntcode"
					value="#{addressListEditPage.businessPagerIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessPagerLoccode"
					value="#{addressListEditPage.businessPagerLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessPagerNumber"
					value="#{addressListEditPage.businessPagerNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessPagerExt"
					value="#{addressListEditPage.businessPagerExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessPager"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistedit.BusinessPagerExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessPagerComment">
				<h:outputText value="#{msgs['addresslistedit.PagerComment']}" />
			</h:outputLabel>
			<h:inputText id="businessPagerComment"
				value="#{addressListEditPage.businessPagerComment}" maxlength="255" />
			<h:message for="businessPagerComment"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="businessEmail1">
				<h:outputText value="#{msgs['addresslistedit.Email1']}" />
			</h:outputLabel>
			<h:inputText id="businessEmail1"
				value="#{addressListEditPage.businessEmail1}" maxlength="255" />
			<h:message for="businessEmail1"></h:message>

			<h:outputLabel for="businessEmail2">
				<h:outputText value="#{msgs['addresslistedit.Email2']}" />
			</h:outputLabel>
			<h:inputText id="businessEmail2"
				value="#{addressListEditPage.businessEmail2}" maxlength="255" />
			<h:message for="businessEmail2"></h:message>

			<h:outputLabel for="businessEmail3">
				<h:outputText value="#{msgs['addresslistedit.Email3']}" />
			</h:outputLabel>
			<h:inputText id="businessEmail3"
				value="#{addressListEditPage.businessEmail3}" maxlength="255" />
			<h:message for="businessEmail3"></h:message>

			<h:outputLabel for="businessUrl1">
				<h:outputText value="#{msgs['addresslistedit.Url1']}" />
			</h:outputLabel>
			<h:inputText id="businessUrl1"
				value="#{addressListEditPage.businessUrl1}" maxlength="255" />
			<h:message for="businessUrl1"></h:message>

			<h:outputLabel for="businessUrl2">
				<h:outputText value="#{msgs['addresslistedit.Url2']}" />
			</h:outputLabel>
			<h:inputText id="businessUrl2"
				value="#{addressListEditPage.businessUrl2}" maxlength="255" />
			<h:message for="businessUrl2"></h:message>

			<h:outputLabel for="businessUrl3">
				<h:outputText value="#{msgs['addresslistedit.Url3']}" />
			</h:outputLabel>
			<h:inputText id="businessUrl3"
				value="#{addressListEditPage.businessUrl3}" maxlength="255" />
			<h:message for="businessUrl3"></h:message>

		</h:panelGrid>

		<t:div styleClass="portlet-section-header">
			<h:outputText value="#{msgs['addresslistedit.CustomInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="custom1">
				<h:outputText value="#{msgs['addresslistedit.Custom1']}" />
			</h:outputLabel>
			<h:inputText id="custom1" value="#{addressListEditPage.custom1}"
				maxlength="255" />
			<h:message for="custom1"></h:message>

			<h:outputLabel for="custom2">
				<h:outputText value="#{msgs['addresslistedit.Custom2']}" />
			</h:outputLabel>
			<h:inputText id="custom2" value="#{addressListEditPage.custom2}"
				maxlength="255" />
			<h:message for="custom2"></h:message>

			<h:outputLabel for="custom3">
				<h:outputText value="#{msgs['addresslistedit.Custom3']}" />
			</h:outputLabel>
			<h:inputText id="custom3" value="#{addressListEditPage.custom3}"
				maxlength="255" />
			<h:message for="custom3"></h:message>

			<h:outputLabel for="custom4">
				<h:outputText value="#{msgs['addresslistedit.Custom4']}" />
			</h:outputLabel>
			<h:inputText id="custom4" value="#{addressListEditPage.custom4}"
				maxlength="255" />
			<h:message for="custom4"></h:message>

		</h:panelGrid>

		<h:inputHidden value="#{addressListEditPage.id}" />

		<h:panelGrid columns="3">
			<h:commandButton action="#{addressListEditPage.update}"
				value="#{msgs['addresslistedit.Update']}"
				rendered="#{addressListEditPage.validUser}" />
			<h:commandButton action="#{addressListEditPage.delete}"
				value="#{msgs['addresslistedit.Delete']}"
				rendered="#{addressListEditPage.validUser}" />
			<h:commandButton action="#{addressListEditPage.back}"
				value="#{msgs['addresslistedit.Back']}" immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
