/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.bean;

import java.util.ArrayList;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;

import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.model.Note;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.model.S2HibernateDataModel;
import com.marevol.utils.faces.util.LocaleUtil;

public class NotepadViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(NotepadViewPageBean.class);

    private NotepadSessionBean notepadSession;

    public String detail()
    {
        ExternalContext exContext = FacesContext.getCurrentInstance().getExternalContext();
        Map map = exContext.getRequestMap();
        Map noteMap = (Map) map.get("note");
        Note note = (Note) noteMap.get("0");
        if (note != null)
        {
            getNotepadSession().setNote(note);
            return NotepadConstants.NOTEPAD_EDIT_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addWarnMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "notepadview.TheSelectedItemIsNull"));
            log.error("The selected Item is null.");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the note items.
     */
    public DataModel getNotes()
    {
        StringBuffer query = new StringBuffer("select note from Note note ");
        String param = "where ";
        ArrayList paramList = new ArrayList();

        query.append(param);
        query.append("note.scope = ? ");
        param = "and ";
        paramList.add(getNotepadSession().getScope());

        String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if (username != null)
        {
            query.append(param);
            query.append("note.owner = ? ");
            param = "and ";
            paramList.add(username);
        }
        else
        {
            query.append(param);
            query.append("note.permission = ? ");
            param = "and ";
            paramList.add(NotepadConstants.PUBLIC_PERMISSION);
        }

        if (getNotepadSession().getCategoryId().longValue() != -1)
        {
            query.append(param);
            query.append("note.category = ? ");
            param = "and ";
            paramList.add(getNotepadSession().getCategory());
        }

        query.append("order by note.name");

        if (log.isDebugEnabled())
        {
            log.debug("getNotes() -  : query=" + query.toString());
        }

        Object[] params = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); i++)
        {
            params[i] = paramList.get(i);
        }

        return new S2HibernateDataModel(query.toString(), params);
    }

    /**
     * @return Returns the notepadSession.
     */
    public NotepadSessionBean getNotepadSession()
    {
        return notepadSession;
    }

    /**
     * @param notepadSession The notepadSession to set.
     */
    public void setNotepadSession(NotepadSessionBean notepadSession)
    {
        this.notepadSession = notepadSession;
    }
}
