/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.util;

import jp.sf.pal.notepad.NotepadRuntimeException;
import jp.sf.pal.notepad.dao.CategoryDao;
import jp.sf.pal.notepad.dao.NoteDao;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class NotepadDaoUtil
{
    public static NoteDao getNoteDao() throws NotepadRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getNoteDao(container);
    }

    public static NoteDao getNoteDao(S2Container container) throws NotepadRuntimeException
    {
        NoteDao noteDao = (NoteDao) container.getComponent(NoteDao.class);
        if (noteDao == null)
        {
            throw new NotepadRuntimeException("NoteDao is null. Check the configuration for S2Container.");
        }
        return noteDao;
    }

    public static CategoryDao getCategoryDao() throws NotepadRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getCategoryDao(container);
    }

    public static CategoryDao getCategoryDao(S2Container container) throws NotepadRuntimeException
    {
        CategoryDao noteDao = (CategoryDao) container.getComponent(CategoryDao.class);
        if (noteDao == null)
        {
            throw new NotepadRuntimeException("CategoryDao is null. Check the configuration for S2Container.");
        }
        return noteDao;
    }

}
