<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.notepad.resources.NotepadResources"
		var="msgs" />

	<!-- Menu -->
	<f:subview id="menu">
	    <jsp:include page="Menubar.jsp"/>
	</f:subview>

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />
			
		<t:dataTable id="noteList" var="note"
			value="#{notepadViewPage.notes}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{notepadSession.pageSize}">
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['notepadviewpage.Name']}" />
				</f:facet>
				<h:commandLink action="#{notepadViewPage.detail}"
					value="#{note['0'].name}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['notepadviewpage.Date']}" />
				</f:facet>
				<h:outputText value="#{note['0'].formattedUpdatedtime}" />
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="noteList" fastStep="10" pageCountVar="pageCount"
				pageIndexVar="pageIndex" paginator="true" paginatorMaxPages="9">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex>1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex>1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="noteList" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				firstRowIndexVar="firstRowIndex" lastRowIndexVar="lastRowIndex"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['notepadviewpage.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['notepadviewpage.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>

	</h:form>

</f:view>
