package jp.sf.pal.todolist.bean;

import java.io.IOException;

import jp.sf.pal.todolist.TodoListConstants;
import jp.sf.pal.todolist.model.Todo;
import jp.sf.pal.todolist.util.TodoListDaoUtil;

import org.seasar.portlet.util.PortletPreferencesUtil;

public class TodoListViewSessionBean
{
    private Boolean all = Boolean.FALSE;

    private Long todoId;

    /**
     * @return Returns the todo.
     */
    public Todo getTodo()
    {
        if (todoId != null)
        {
            return TodoListDaoUtil.getTodoDao().getTodoById(todoId.longValue());
        }
        else
        {
            return null;
        }
    }

    /**
     * @param todo The todo to set.
     */
    public void setTodo(Todo todo)
    {
        if (todo != null)
        {
            todoId = new Long(todo.getId());
        }
        else
        {
            todoId = null;
        }
    }

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {

        return new Integer(PortletPreferencesUtil.getValue(
                TodoListConstants.VIEW_PAGE_SIZE, Integer
                        .toString(TodoListConstants.DEFAULT_PAGE_SIZE)));
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer maxResults) throws IOException
    {

        PortletPreferencesUtil.setValue(TodoListConstants.VIEW_PAGE_SIZE,
                maxResults.toString());

    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {

        return PortletPreferencesUtil
                .getValue(TodoListConstants.VIEW_OWNER, "");
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String owner) throws IOException
    {

        PortletPreferencesUtil.setValue(TodoListConstants.VIEW_OWNER, owner);

    }

    /**
     * @return Returns the all.
     */
    public Boolean getAll()
    {
        return all;
    }

    /**
     * @param all The all to set.
     */
    public void setAll(Boolean all)
    {
        this.all = all;
    }

}
