/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.todolist.model;

// Generated Jan 16, 2006 7:35:43 AM by Hibernate Tools 3.1.0 beta1JBIDERC2

import java.util.Date;

import jp.sf.pal.todolist.TodoListConstants;

import com.marevol.utils.faces.util.DateFormatUtil;

/**
 * Todo generated by hbm2java
 */

public class Todo implements java.io.Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = 3729896488996634484L;

    // Fields    

    private long id;

    private String owner;

    private String title;

    private String description;

    private Date createdtime;

    private Date duedate;

    private String status;

    private String viewmode;

    // Constructors

    /** default constructor */
    public Todo()
    {
    }

    /** minimal constructor */
    public Todo(long id)
    {
        this.id = id;
    }

    /** full constructor */
    public Todo(long id, String owner, String title, String description,
            Date createdtime, Date duedate, String status, String viewmode)
    {
        this.id = id;
        this.owner = owner;
        this.title = title;
        this.description = description;
        this.createdtime = createdtime;
        this.duedate = duedate;
        this.status = status;
        this.viewmode = viewmode;
    }

    // Property accessors

    public long getId()
    {
        return this.id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public String getOwner()
    {
        return this.owner;
    }

    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    public String getTitle()
    {
        return this.title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getDescription()
    {
        return this.description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    public Date getCreatedtime()
    {
        return this.createdtime;
    }

    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    public Date getDuedate()
    {
        return this.duedate;
    }

    public void setDuedate(Date duedate)
    {
        this.duedate = duedate;
    }

    public String getStatus()
    {
        return this.status;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getFormattedShortDuedate()
    {
        if (getDuedate() == null)
        {
            return TodoListConstants.NONEXISTENT_VALUE;
        }

        return DateFormatUtil.getShortFormattedDateTime(getDuedate());
    }

    public String getStatusbar()
    {
        if (getStatus().equals(TodoListConstants.STATUS_0))
        {
            return TodoListConstants.PROGRESS_0;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_10))
        {
            return TodoListConstants.PROGRESS_10;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_20))
        {
            return TodoListConstants.PROGRESS_20;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_30))
        {
            return TodoListConstants.PROGRESS_30;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_40))
        {
            return TodoListConstants.PROGRESS_40;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_50))
        {
            return TodoListConstants.PROGRESS_50;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_60))
        {
            return TodoListConstants.PROGRESS_60;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_70))
        {
            return TodoListConstants.PROGRESS_70;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_80))
        {
            return TodoListConstants.PROGRESS_80;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_90))
        {
            return TodoListConstants.PROGRESS_90;
        }
        else if (getStatus().equals(TodoListConstants.STATUS_100))
        {
            return TodoListConstants.PROGRESS_100;
        }
        return TodoListConstants.PROGRESS_0;
    }

    /**
     * @return Returns the viewmode.
     */
    public String getViewmode()
    {
        return viewmode;
    }

    /**
     * @param viewmode The viewmode to set.
     */
    public void setViewmode(String viewmode)
    {
        this.viewmode = viewmode;
    }
}
