<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.todolist.resources.TodoListResources"
		var="msgs" />

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />
		<h:panelGrid columns="3" rendered="#{todoListEditPage.validUser}">
			<h:outputLabel for="title">
				<h:outputText value="#{msgs['todolistedit.Title']}" />
			</h:outputLabel>
			<h:inputText id="title" value="#{todoListEditPage.title}"
				maxlength="64" rendered="#{todoListEditPage.validUser}" />
			<h:message for="title"></h:message>

			<h:outputLabel for="description">
				<h:outputText value="#{msgs['todolistedit.Description']}" />
			</h:outputLabel>
			<h:inputText id="description" value="#{todoListEditPage.description}"
				maxlength="255" rendered="#{todoListEditPage.validUser}" />
			<h:message for="description"></h:message>

			<h:outputLabel for="duedate">
				<h:outputText value="#{msgs['todolistedit.DueDate']}" />
			</h:outputLabel>
			<h:panelGrid columns="4" id="duedate"
				rendered="#{todoListEditPage.validUser}">
				<t:inputCalendar id="duecal" value="#{todoListEditPage.dueDate}"
					required="true" renderAsPopup="true" popupTodayString="Today"
					popupWeekString="Wk" popupDateFormat="yyyy-MM-dd"
					renderPopupButtonAsImage="true" />
				<h:selectOneMenu value="#{todoListEditPage.dueHour}">
					<f:selectItems value="#{todoListEditPage.dueHourItems}" />
				</h:selectOneMenu>
				<h:outputText value="#{msgs['todolistedit.colon']}" />
				<h:selectOneMenu value="#{todoListEditPage.dueMin}">
					<f:selectItems value="#{todoListEditPage.dueMinItems}" />
				</h:selectOneMenu>
			</h:panelGrid>
			<h:message for="duecal"></h:message>

			<h:outputLabel for="publicview">
				<h:outputText value="#{msgs['todolistedit.Public']}" />
			</h:outputLabel>
			<h:selectBooleanCheckbox id="publicview"
				value="#{todoListEditPage.publicView}"
				disabled="#{!todoListEditPage.validUser}" />
			<h:message for="publicview"></h:message>

			<h:outputLabel for="owner">
				<h:outputText value="#{msgs['todolistedit.Username']}" />
			</h:outputLabel>
			<h:inputText id="owner" value="#{todoListEditPage.owner}"
				maxlength="255" rendered="#{todoListEditPage.validUser}" />
			<h:message for="owner"></h:message>

			<h:outputLabel for="status">
				<h:outputText value="#{msgs['todolistedit.Status']}" />
			</h:outputLabel>
			<h:selectOneMenu id="status" value="#{todoListEditPage.status}"
				disabled="#{!todoListEditPage.validUser}">
				<f:selectItems value="#{todoListEditPage.statusItems}" />
			</h:selectOneMenu>
			<h:message for="status"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="2" rendered="#{!todoListEditPage.validUser}">
			<h:outputLabel for="vtitle">
				<h:outputText value="#{msgs['todolistedit.Title']}" />
			</h:outputLabel>
			<h:outputText id="vtitle" value="#{todoListEditPage.title}"
				rendered="#{!todoListEditPage.validUser}" />

			<h:outputLabel for="vdescription">
				<h:outputText value="#{msgs['todolistedit.Description']}" />
			</h:outputLabel>
			<h:outputText id="vdescription"
				value="#{todoListEditPage.description}"
				rendered="#{!todoListEditPage.validUser}" />

			<h:outputLabel for="vduedate">
				<h:outputText value="#{msgs['todolistedit.DueDate']}" />
			</h:outputLabel>
			<h:outputText id="vduedate"
				value="#{todoListEditPage.formattedDueDate}"
				rendered="#{!todoListEditPage.validUser}" />

			<h:outputLabel for="vpublicview">
				<h:outputText value="#{msgs['todolistedit.Public']}" />
			</h:outputLabel>
			<h:selectBooleanCheckbox id="vpublicview"
				value="#{todoListEditPage.publicView}"
				disabled="#{!todoListEditPage.validUser}" />

			<h:outputLabel for="vowner">
				<h:outputText value="#{msgs['todolistedit.Username']}" />
			</h:outputLabel>
			<h:outputText id="vowner" value="#{todoListEditPage.owner}"
				rendered="#{!todoListEditPage.validUser}" />

			<h:outputLabel for="vstatus">
				<h:outputText value="#{msgs['todolistedit.Status']}" />
			</h:outputLabel>
			<h:selectOneMenu id="vstatus" value="#{todoListEditPage.status}"
				disabled="#{!todoListEditPage.validUser}">
				<f:selectItems value="#{todoListEditPage.statusItems}" />
			</h:selectOneMenu>

		</h:panelGrid>

		<h:inputHidden value="#{todoListEditPage.id}" />

		<h:panelGrid columns="3">
			<h:commandButton action="#{todoListEditPage.update}" value="#{msgs['todolistedit.Update']}"
				rendered="#{todoListEditPage.validUser}" />
			<h:commandButton action="#{todoListEditPage.delete}" value="#{msgs['todolistedit.Delete']}"
				rendered="#{todoListEditPage.validUser}" />
			<h:commandButton action="#{todoListEditPage.back}" value="#{msgs['todolistedit.Back']}"
				immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
