/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jsfhelloworld.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.sf.pal.jsfhelloworld.JSFHellloWorldConstants;

public class SayHelloPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(SayHelloPageBean.class);

    private JSFHelloWorldSessionBean jsfHelloWorldSession;

    public String back()
    {
        if (log.isDebugEnabled())
        {
            log.debug("back()");
        }

        return JSFHellloWorldConstants.NAVI_TO_INPUTNAME;
    }

    /**
     * @return Returns the jsfHelloWorldSession.
     */
    public JSFHelloWorldSessionBean getJsfHelloWorldSession()
    {
        return jsfHelloWorldSession;
    }

    /**
     * @param jsfHelloWorldSession The jsfHelloWorldSession to set.
     */
    public void setJsfHelloWorldSession(
            JSFHelloWorldSessionBean jsfHelloWorldSession)
    {
        this.jsfHelloWorldSession = jsfHelloWorldSession;
    }
}
