/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.IOException;
import java.util.ArrayList;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogComment;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletPreferencesUtil;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.util.LocaleUtil;

public class BlogCommentTitleViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(BlogCommentTitleViewEditPageBean.class);

    private String owner;

    private String sortColumn;

    private Integer pageSize;

    private Object[] displayedItems;

    private BlogCommentTitleViewSessionBean commentTitleViewSession;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        try
        {
            getCommentTitleViewSession().setOwner(owner);
            getCommentTitleViewSession().setPageSize(pageSize);
            //            getTitleViewSession().setSortColumn(sortColumn);

            if (displayedItems != null)
            {
                String createdtime = BlogConstants.FALSE;
                //                String updatedtime = BlogConstants.FALSE;
                for (int i = 0; i < displayedItems.length; i++)
                {
                    if (displayedItems[i].equals(BlogComment.CREATEDTIME))
                    {
                        createdtime = BlogConstants.TRUE;
                        //                    }
                        //                    else if (displayedItems[i].equals(BlogComment.UPDATEDTIME))
                        //                    {
                        //                        updatedtime = BlogConstants.TRUE;
                    }
                }

                if (!getCommentTitleViewSession().getDisplayCreatedtime()
                        .equals(createdtime))
                {
                    getCommentTitleViewSession().setDisplayCreatedtime(
                            new Boolean(createdtime));
                }
                //                if (!getTitleViewSession().getDisplayUpdatedtime().equals(updatedtime))
                //                {
                //                    getTitleViewSession().setDisplayUpdatedtime(new Boolean(updatedtime));
                //                }

                PortletPreferencesUtil.store();

                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                        .getString(LocaleUtil.getLocale(),
                                "blogcommenttitleview.UpdatedParameters"));

            }
            else
            {
                // i18n
                FacesMessageUtil
                        .addErrorMessage(PortletResourceBundleUtil
                                .getString(LocaleUtil.getLocale(),
                                        "blogcommenttitleview.TheSpecifiedItemsAreInvalid"));
                if (log.isDebugEnabled())
                {
                    log.debug("setDisplayedItems(Object[]) - items is null.");
                }
            }

        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogcommenttitleview.SystemErrorOccurs"), e
                    .toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (log.isDebugEnabled())
        {
            log.debug("reset() - start");
        }

        try
        {
            getCommentTitleViewSession().setOwner(
                    FacesContext.getCurrentInstance().getExternalContext()
                            .getRemoteUser());
            getCommentTitleViewSession().setPageSize(
                    new Integer(BlogConstants.DEFAULT_PAGE_SIZE));
            getCommentTitleViewSession().setSortColumn(BlogComment.CREATEDTIME);
            getCommentTitleViewSession().setDisplayCreatedtime(
                    new Boolean(BlogConstants.FALSE));
            //            getTitleViewSession().setDisplayUpdatedtime(new Boolean(BlogConstants.FALSE));

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogcommenttitleview.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogcommenttitleview.SystemErrorOccurs"), e
                    .toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("reset() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - end");
        }
        //        return pageSize;
        return commentTitleViewSession.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - start");
        }

        this.pageSize = number;

        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - end");
        }
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - end");
        }
        //return owner;
        return commentTitleViewSession.getOwner();
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String targetUser)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - start");
        }

        this.owner = targetUser;

        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - end");
        }
    }

    /**
     * @return Returns the commentTitleViewSession.
     */
    public BlogCommentTitleViewSessionBean getCommentTitleViewSession()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return commentTitleViewSession;
    }

    /**
     * @param commentTitleViewSession The commentTitleViewSession to set.
     */
    public void setCommentTitleViewSession(
            BlogCommentTitleViewSessionBean titleViewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log
                    .debug("setTitleViewPortlet(BlogCommentTitleViewSessionBean) - start");
        }

        this.commentTitleViewSession = titleViewPortlet;

        if (log.isDebugEnabled())
        {
            log
                    .debug("setTitleViewPortlet(BlogCommentTitleViewSessionBean) - end");
        }
    }

    /**
     * @return Returns the sortColumn.
     */
    public String getSortColumn()
    {
        return getCommentTitleViewSession().getSortColumn();
    }

    /**
     * @param sortColumn The sortColumn to set.
     */
    public void setSortColumn(String sortColumn)
    {
        this.sortColumn = sortColumn;
    }

    public Object[] getDisplayedItems()
    {
        ArrayList items = new ArrayList();
        if (getCommentTitleViewSession().getDisplayCreatedtime().booleanValue())
        {
            items.add(BlogComment.CREATEDTIME);
        }
        //        if (getTitleViewSession().getDisplayUpdatedtime().booleanValue())
        //        {
        //            items.add(BlogComment.UPDATEDTIME);
        //        }
        return items.toArray();
    }

    public void setDisplayedItems(Object[] items)
    {
        displayedItems = items;
    }

}
