/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.faces.context.FacesContext;

import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;
import jp.sf.grizzly.storage.impl.ByteArrayStreamStorageImpl;
import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.converter.Converter;
import jp.sf.pal.blog.util.BlogCommentComparator;
import jp.sf.pal.blog.util.BlogTrackbackComparator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.portlet.util.RenderResponseUtil;

import com.marevol.utils.faces.util.DateFormatUtil;

/**
 * BlogMessage generated by hbm2java
 */
public class BlogMessage implements java.io.Serializable
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogMessage.class);

    /**
     * 
     */
    private static final long serialVersionUID = -5551793167782445984L;

    public static final String ID = "id";

    public static final String OWNER = "owner";

    public static final String TITLE = "title";

    public static final String MESSAGE = "message";

    public static final String CREATEDTIME = "createdtime";

    public static final String UPDATEDTIME = "updatedtime";

    // Fields    

    private Long id;

    private BlogCategory blogcategory;

    private String owner;

    private String title;

    private String message;

    private String formattype;

    private Date createdtime;

    private Date updatedtime;

    private Set blogcomments;

    private Set blogtrackbacks;

    // Constructors

    /** default constructor */
    public BlogMessage()
    {
    }

    /** constructor with id */
    public BlogMessage(Long id)
    {
        this.id = id;
    }

    // Property accessors

    /**
     * 
     */
    public Long getId()
    {
        return this.id;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * 
     */
    public BlogCategory getBlogCategory()
    {
        return this.blogcategory;
    }

    public void setBlogCategory(BlogCategory blogcategory)
    {
        this.blogcategory = blogcategory;
    }

    /**
     * 
     */
    public String getOwner()
    {
        return this.owner;
    }

    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    /**
     * 
     */
    public String getTitle()
    {
        return this.title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * 
     */
    public String getMessage()
    {
        return this.message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    /**
     * 
     */
    public String getFormattype()
    {
        return this.formattype;
    }

    public void setFormattype(String formattype)
    {
        this.formattype = formattype;
    }

    /**
     * 
     */
    public Date getCreatedtime()
    {
        return this.createdtime;
    }

    public void setCreatedtime(Date createdtime)
    {
        this.createdtime = createdtime;
    }

    /**
     * 
     */
    public Date getUpdatedtime()
    {
        return this.updatedtime;
    }

    public void setUpdatedtime(Date updatedtime)
    {
        this.updatedtime = updatedtime;
    }

    /**
     * 
     */
    public Set getBlogComments()
    {
        return this.blogcomments;
    }

    public void setBlogComments(Set blogcomments)
    {
        this.blogcomments = blogcomments;
    }

    /**
     * 
     */
    public Set getBlogTrackbacks()
    {
        return this.blogtrackbacks;
    }

    public void setBlogTrackbacks(Set blogtrackbacks)
    {
        this.blogtrackbacks = blogtrackbacks;
    }

    public String getRedirectUrl()
    {
        StringBuffer redirectUrl = new StringBuffer();
        String url = RenderResponseUtil.createRenderURL().toString();
        String fragment = null;
        int fragmentIndex = url.indexOf("#");
        if (fragmentIndex >= 0)
        {
            redirectUrl.append(url.substring(0, fragmentIndex));
            fragment = url.substring(fragmentIndex);
        }
        else
        {
            redirectUrl.append(url);
            fragment = "";
        }
        if (url.indexOf("?") < 0)
        {
            redirectUrl.append("?");
        }
        else
        {
            redirectUrl.append("&");
        }
        redirectUrl.append(FacesContext.getCurrentInstance()
                .getExternalContext().encodeNamespace(
                        BlogConstants.BLOG_REDIRECT_ID));
        redirectUrl.append("=");
        redirectUrl.append(getId().toString());

        redirectUrl.append(fragment);

        if (log.isDebugEnabled())
        {
            log.debug("getRedirectUrl() - redirectUrl=" + redirectUrl
                    + ", url=" + url + ", fragment=" + fragment
                    + ", fragmentIndex=" + fragmentIndex);
        }

        return redirectUrl.toString();
    }

    public void setRedirectUrl(String url)
    {
        // NONE
    }

    public String getFormattedMessage()
    {

        S2Container container = SingletonS2ContainerFactory.getContainer();

        List list = (List) container.getComponent(BlogConstants.CONVERTER_LIST);
        Iterator ite = list.iterator();
        while (ite.hasNext())
        {
            Object obj = ite.next();
            if (obj instanceof Converter)
            {
                Converter converter = (Converter) obj;
                if (converter.getFormatType().equals(getFormattype()))
                {
                    StringBuffer buffer = new StringBuffer();
                    try
                    {
                        StreamStorage storage;
                        try
                        {
                            storage = new ByteArrayStreamStorageImpl(
                                    new ByteArrayInputStream(getMessage()
                                            .getBytes(BlogConstants.UTF_8)),
                                    BlogConstants.UTF_8);
                        }
                        catch (UnsupportedEncodingException e1)
                        {
                            log.warn("Unsupported encoding. ", e1);
                            storage = new ByteArrayStreamStorageImpl(
                                    new ByteArrayInputStream(getMessage()
                                            .getBytes()), BlogConstants.UTF_8);
                        }
                        converter.getConverter().invoke(storage);

                        BufferedReader r = null;
                        try
                        {
                            r = new BufferedReader(new InputStreamReader(
                                    storage.getResultInputStream(), storage
                                            .getEncoding()));
                            String l = null;
                            while ((l = r.readLine()) != null)
                            {
                                buffer.append(l);
                                buffer.append("\n");
                            }
                        }
                        catch (UnsupportedEncodingException e)
                        {
                            log.warn("Unsupported Encoding. ", e);
                        }
                        catch (StreamStorageException e)
                        {
                            log.warn("Stream Storage Exception. ", e);
                        }
                        catch (IOException e)
                        {
                            log.error("I/O Exception. ", e);
                        }
                        finally
                        {
                            if (r != null)
                            {
                                try
                                {
                                    r.close();
                                }
                                catch (IOException e)
                                {
                                }
                            }
                        }
                        storage.destroy();
                        return buffer.toString();
                    }
                    catch (StreamStorageException e)
                    {
                        log.error("StreamStorage Exception.", e);
                        return getMessage();
                    }
                    catch (PipelineException e)
                    {
                        log.error("Pipeline Exception.", e);
                        return getMessage();
                    }
                }
            }
            else
            {
                log.warn("Invalid converter: " + obj);
                return getMessage();
            }
        }

        return getMessage();
    }

    public String getFormattedUpdatedtime()
    {
        return DateFormatUtil.getMediumFormattedDateTime(getUpdatedtime());
    }

    public String getFormattedCreatedtime()
    {
        return DateFormatUtil.getMediumFormattedDateTime(getCreatedtime());
    }

    public String getAbbreviatedTitle()
    {
        return getAbbreviatedTitle(BlogConstants.DEFAULT_TITLE_MAX_LENGTH);
    }

    public String getAbbreviatedTitle(int maxLength)
    {
        return StringUtils.abbreviate(getTitle(), maxLength);
    }

    public void setAbbreviatedTitle(String title)
    {
        setTitle(title);
    }

    public int getBlogCommentSize()
    {
        if (getBlogComments() != null)
        {
            return getBlogComments().size();
        }
        return 0;
    }

    public int getBlogTrackbackSize()
    {
        if (getBlogTrackbacks() != null)
        {
            return getBlogTrackbacks().size();
        }
        return 0;
    }

    public String getTrackbackUrl()
    {
        return FacesContext.getCurrentInstance().getExternalContext()
                .getRequestContextPath()
                + "/trackback/" + getId();
    }

    public Set getSortedBlogComments()
    {
        TreeSet ts = new TreeSet(new BlogCommentComparator(
                BlogCommentComparator.ASC));
        ts.addAll(getBlogComments());
        return (Set) ts;
    }

    public Set getSortedBlogTrackbacks()
    {
        TreeSet ts = new TreeSet(new BlogTrackbackComparator(
                BlogTrackbackComparator.ASC));
        ts.addAll(getBlogTrackbacks());
        return (Set) ts;
    }

    /**
     * @return Returns the emptyTitle.
     */
    public boolean isEmptyTitle()
    {
        return StringUtils.isEmpty(getTitle());
    }

    /**
     * @param emptyTitle The emptyTitle to set.
     */
    public void setEmptyTitle(boolean emptyTitle)
    {
    }
}
