/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.tomahawk.filter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sf.pal.facesresponse.io.BufferedResponseStream;
import jp.sf.pal.facesresponse.io.BufferedResponseStreamFactory;
import jp.sf.pal.tomahawk.handler.ResourceHandlerImpl;
import jp.sf.pal.tomahawk.multipart.MultipartPortletRequestWrapper;
import jp.sf.pal.tomahawk.wrapper.HttpServletRequestWrapper;
import jp.sf.pal.tomahawk.wrapper.HttpServletResponseWrapper;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.webapp.filter.ExtensionsResponseWrapper;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class ExtensionsPortletFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)ExtensionsPortletFilter.class);
    private static final int BLOCK_SIZE = 4096;
    private static final String UPLOAD_REPOSITORY_PATH = "uploadRepositoryPath";
    private static final String UPLOAD_THRESHOLD_SIZE = "uploadThresholdSize";
    private static final String UPLOAD_MAX_FILE_SIZE = "uploadMaxFileSize";
    private int uploadMaxFileSize = 0x6400000;
    private int uploadThresholdSize = 0x100000;
    private String uploadRepositoryPath = null;
    private PortletConfig portletConfig;

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing ExtensionsPortletFilter.");
        }
        this.setPortletConfig(filterConfig.getPortletConfig());
        String param = filterConfig.getInitParameter(UPLOAD_MAX_FILE_SIZE);
        this.uploadMaxFileSize = this.resolveSize(param, this.uploadMaxFileSize);
        param = filterConfig.getInitParameter(UPLOAD_THRESHOLD_SIZE);
        this.uploadThresholdSize = this.resolveSize(param, this.uploadThresholdSize);
        this.uploadRepositoryPath = filterConfig.getInitParameter(UPLOAD_REPOSITORY_PATH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("uploadMaxFileSize=" + this.uploadMaxFileSize));
            log.debug((Object)("uploadThresholdSize=" + this.uploadThresholdSize));
            log.debug((Object)("uploadRepositoryPath=" + this.uploadRepositoryPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called renderFilter.");
            log.debug((Object)("RenderRequest=" + request.getClass().getName()));
            log.debug((Object)("RenderResponse=" + response.getClass().getName()));
        }
        if (request.getAttribute("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled") != null) {
            chain.renderFilter(request, response);
            return;
        }
        request.setAttribute("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled", (Object)"true");
        HttpServletRequestWrapper extendedRequest = new HttpServletRequestWrapper((PortletRequest)request, this.getPortletConfig().getPortletContext());
        AddResource addResource = null;
        try {
            addResource = AddResourceFactory.getInstance((HttpServletRequest)extendedRequest);
        }
        catch (Throwable th) {
            log.error((Object)"Exception while retrieving addResource", th);
            throw new PortletException(th);
        }
        try {
            addResource.responseStarted();
            if (addResource.requiresBuffer()) {
                HttpServletResponseWrapper servletResponse = new HttpServletResponseWrapper(response);
                ExtensionsResponseWrapper extendedResponse = new ExtensionsResponseWrapper((HttpServletResponse)servletResponse);
                chain.renderFilter(request, response);
                BufferedResponseStream bufferedResponseStream = BufferedResponseStreamFactory.getBufferedResponseStream((PortletRequest)request);
                if (bufferedResponseStream != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - bufferedResponseStream=" + bufferedResponseStream));
                    }
                    bufferedResponseStream.commit();
                    Reader reader = bufferedResponseStream.getReader();
                    BufferedWriter writer = new BufferedWriter(bufferedResponseStream.getWriter());
                    addResource.parseResponse((HttpServletRequest)extendedRequest, ResourceHandlerImpl.HTML_CONTENTS, (HttpServletResponse)servletResponse);
                    addResource.writeMyFacesJavascriptBeforeBodyEnd((HttpServletRequest)extendedRequest, (HttpServletResponse)servletResponse);
                    addResource.writeWithFullHeader((HttpServletRequest)extendedRequest, (HttpServletResponse)extendedResponse);
                    addResource.writeResponse((HttpServletRequest)extendedRequest, (HttpServletResponse)extendedResponse);
                    extendedResponse.finishResponse();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter extendedResponse.toString()=" + extendedResponse.toString()));
                    }
                    ResourceHandlerImpl resourceHandler = new ResourceHandlerImpl();
                    resourceHandler.parse(extendedResponse.toString());
                    resourceHandler.renderBeforeContents(response, writer);
                    resourceHandler.addResourcesToHead(request, response, writer);
                    resourceHandler.renderResourcesBeforeContents(request, response, writer);
                    this.drain(reader, writer);
                    resourceHandler.renderResourcesAfterContents(request, response, writer);
                    writer.flush();
                    bufferedResponseStream.commit();
                }
            } else {
                chain.renderFilter(request, response);
            }
        }
        finally {
            addResource.responseFinished();
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called processActionFilter.");
        }
        if (PortletFileUpload.isMultipartContent((ActionRequest)request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ActionRequest is multipart content.");
            }
            request = new MultipartPortletRequestWrapper(request, this.uploadMaxFileSize, this.uploadThresholdSize, this.uploadRepositoryPath);
        }
        chain.processActionFilter(request, response);
    }

    public void destroy() {
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public boolean isValidContentType(String contentType) {
        return contentType.startsWith("text/html") || contentType.startsWith("text/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain(Reader r, Writer w) throws IOException {
        char[] bytes = new char[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }
}

