/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletInfoNode;
import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletNode;
import jp.sf.pal.facesdevfilter.util.Enumerator;

public class PortletResourceBundle
extends ResourceBundle {
    private static final String JAVAX_PORTLET_KEYWORDS = "javax.portlet.keywords";
    private static final String JAVAX_PORTLET_SHORT_TITLE = "javax.portlet.short-title";
    private static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    private PortletNode portlet;
    private ResourceBundle parent;

    public PortletResourceBundle(PortletNode portlet, Locale locale) {
        if (portlet.getResourceBundle() != null) {
            this.parent = ResourceBundle.getBundle(portlet.getResourceBundle(), locale);
            this.setParent(this.parent);
        } else {
            this.parent = null;
        }
        this.portlet = portlet;
    }

    public Enumeration getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(JAVAX_PORTLET_TITLE);
        keys.add(JAVAX_PORTLET_SHORT_TITLE);
        keys.add(JAVAX_PORTLET_KEYWORDS);
        if (this.parent != null) {
            Enumeration<String> pKeys = this.parent.getKeys();
            while (pKeys.hasMoreElements()) {
                keys.add(pKeys.nextElement());
            }
        }
        return new Enumerator(keys.iterator());
    }

    protected Object handleGetObject(String key) {
        PortletInfoNode portletInfo = this.portlet.getPortletInfo();
        if (JAVAX_PORTLET_TITLE.equals(key)) {
            if (portletInfo == null) {
                return "";
            }
            if (portletInfo.getTitle() == null) {
                return "";
            }
            return portletInfo.getTitle();
        }
        if (JAVAX_PORTLET_SHORT_TITLE.equals(key)) {
            if (portletInfo == null) {
                return "";
            }
            if (portletInfo.getShortTitle() == null) {
                return "";
            }
            return portletInfo.getShortTitle();
        }
        if (JAVAX_PORTLET_KEYWORDS.equals(key)) {
            if (portletInfo == null) {
                return "";
            }
            if (portletInfo.getKeywords() == null) {
                return "";
            }
            return portletInfo.getKeywords();
        }
        return null;
    }
}

