/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.portlet.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author shinsuke
 * 
 */
public class PortletNode {
    /** The unique name of the portlet. */
    private String portletName;

    /** The class which implements the portlet interface. */
    private String portletClass;

    /** All security role references. */
    private List securityRoleRefs = new ArrayList();

    private Map initParams;

    private List mimeTypes;

    private List portletModes;

    private String resourceBundle;

    private PortletInfoNode portletInfo;

    // TODO display-name
    // TODO description
    // TODO expiration-cache
    // TODO supported-locale
    // TODO portlet-preferences

    /**
     * Default Constructor.
     */
    public PortletNode() {

    }

    /**
     * Retrieve the unique name of the portlet.
     * 
     * @return
     */
    public String getPortletName() {
        return portletName;
    }

    /**
     * Set the unique name of the portlet.
     * 
     * @param portletName
     */
    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    /**
     * Retrieve the name of the portlet class.
     * 
     * @return the fully qualified portlet class name.
     */
    public String getPortletClass() {
        return portletClass;
    }

    /**
     * Set the name of the portlet class.
     * 
     * @param portletClass
     */
    public void setPortletClass(String portletClass) {
        this.portletClass = portletClass;
    }

    /**
     * Retrieve the security role references for this portlet.
     * 
     * @return
     */
    public List getSecurityRoleRefs() {
        return securityRoleRefs;
    }

    /**
     * Set the security role references for this portlet.
     * 
     * @param securityRoleRefs
     */
    public void setSecurityRoleRefs(List securityRoleRefs) {
        this.securityRoleRefs = securityRoleRefs;
    }

    /**
     * @return Returns the initParams.
     */
    public Map getInitParams() {
        return initParams;
    }

    /**
     * @param initParams
     *            The initParams to set.
     */
    public void setInitParams(Map initParams) {
        this.initParams = initParams;
    }

    /**
     * @return Returns the mimeTypes.
     */
    public List getMimeTypes() {
        return mimeTypes;
    }

    /**
     * @param mimeTypes
     *            The mimeTypes to set.
     */
    public void setMimeTypes(List mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    /**
     * @return Returns the portletModes.
     */
    public List getPortletModes() {
        return portletModes;
    }

    /**
     * @param portletModes
     *            The portletModes to set.
     */
    public void setPortletModes(List portletModes) {
        this.portletModes = portletModes;
    }

    /**
     * @return Returns the resourceBundle.
     */
    public String getResourceBundle() {
        return resourceBundle;
    }

    /**
     * @param resourceBundle
     *            The resourceBundle to set.
     */
    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    /**
     * @return Returns the portletInfo.
     */
    public PortletInfoNode getPortletInfo() {
        return portletInfo;
    }

    /**
     * @param portletInfo
     *            The portletInfo to set.
     */
    public void setPortletInfo(PortletInfoNode portletInfo) {
        this.portletInfo = portletInfo;
    }

}
