/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;

import jp.sf.pal.facesdevfilter.util.Enumerator;

public class ContainerInfo {
    public static final ResourceBundle CONTAINER_INFO;

    static {
        CONTAINER_INFO = ResourceBundle
                .getBundle("jp.sf.pal.facesdevfilter.resources.ContainerInfo");
    }

    public static final String getString(String name) {
        return CONTAINER_INFO.getString(name);
    }

    public static final Enumeration getKeys() {
        return CONTAINER_INFO.getKeys();
    }

    public static final String getPortletContainerName() {
        return getString("container.name");
    }

    public static final String getPortletContainerMajorVersion() {
        return getString("container.version.major");
    }

    public static final String getPortletContainerMinorVersion() {
        return getString("container.version.minor");
    }

    public static final int getMajorSpecificationVersion() {
        return Integer.parseInt(getString("javax.portlet.version.major"));
    }

    public static final int getMinorSpecificationVersion() {
        return Integer.parseInt(getString("javax.portlet.version.minor"));
    }

    public static final Enumeration getSupportedPortletModes() {
        String portletModes = getString("supported.portlet.modes");
        if (portletModes == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        String[] modes = portletModes.split(",");
        for (int i = 0; i < modes.length; i++) {
            list.add(new PortletMode(modes[i]));
        }
        return new Enumerator(list.iterator());
    }

    public static final Enumeration getSupportedWindowStates() {
        String windowStates = getString("supported.window.states");
        if (windowStates == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        String[] states = windowStates.split(",");
        for (int i = 0; i < states.length; i++) {
            list.add(new WindowState(states[i]));
        }
        return new Enumerator(list.iterator());
    }

    public static final String getServerInfo() {
        StringBuffer sb = new StringBuffer(getPortletContainerName()).append(
                getString("container.separator")).append(
                getPortletContainerMajorVersion()).append(".").append(
                getPortletContainerMinorVersion());
        return sb.toString();
    }
}
