/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletNode;
import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletInfoNode;
import jp.sf.pal.facesdevfilter.util.Enumerator;

/**
 * @author shinsuke
 * 
 */
public class PortletResourceBundle extends ResourceBundle {
    /**
     * 
     */
    private static final String JAVAX_PORTLET_KEYWORDS = "javax.portlet.keywords";

    /**
     * 
     */
    private static final String JAVAX_PORTLET_SHORT_TITLE = "javax.portlet.short-title";

    /**
     * 
     */
    private static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";

    private PortletNode portlet;

    private ResourceBundle parent;

    public PortletResourceBundle(PortletNode portlet, Locale locale) {
        if (portlet.getResourceBundle() != null) {
            parent = ResourceBundle.getBundle(portlet.getResourceBundle(),
                    locale);
            setParent(parent);
        } else {
            parent = null;
        }
        this.portlet = portlet;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.util.ResourceBundle#getKeys()
     */
    public Enumeration getKeys() {
        ArrayList keys = new ArrayList();
        keys.add(JAVAX_PORTLET_TITLE);
        keys.add(JAVAX_PORTLET_SHORT_TITLE);
        keys.add(JAVAX_PORTLET_KEYWORDS);
        if (parent != null) {
            Enumeration pKeys = parent.getKeys();
            while (pKeys.hasMoreElements()) {
                keys.add(pKeys.nextElement());
            }
        }
        return new Enumerator(keys.iterator());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.util.ResourceBundle#handleGetObject(java.lang.String)
     */
    protected Object handleGetObject(String key) {
        PortletInfoNode portletInfo = portlet.getPortletInfo();
        if (JAVAX_PORTLET_TITLE.equals(key)) {
            if (portletInfo == null) {
                return "";
            }
            if (portletInfo.getTitle() == null) {
                return "";
            }
            return portletInfo.getTitle();
        } else if (JAVAX_PORTLET_SHORT_TITLE.equals(key)) {
            if (portletInfo == null) {
                return "";
            }
            if (portletInfo.getShortTitle() == null) {
                return "";
            }
            return portletInfo.getShortTitle();
        } else if (JAVAX_PORTLET_KEYWORDS.equals(key)) {
            if (portletInfo == null) {
                return "";
            }
            if (portletInfo.getKeywords() == null) {
                return "";
            }
            return portletInfo.getKeywords();
        }

        return null;
    }

}
