/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.vfs.helper;

import org.apache.commons.vfs.FileObject;

/**
 * @author shinsuke
 *
 */
public interface FileParameterHelper {

    /**
     * @return
     */
    public abstract FileObject getFileObject();

    /**
     * @param object
     */
    public abstract void setFileObject(FileObject object);

    public abstract String getBaseName();

    public abstract String getURI();

    public abstract String getParentURI();

    public abstract long getSize();

    public abstract boolean isFolder();

    public abstract boolean isFile();

    public abstract String getFormattedSize();

    public abstract String getContentType();

    public abstract String getFormattedLastModifiedTime();

    /**
     * @return Returns the time.
     */
    public abstract long getTime();

    /**
     * @param time
     *            The time to set.
     */
    public abstract void setTime(long time);

}