/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.servlets;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.vfs.VFSConstants;
import jp.sf.pal.vfs.helper.DownloadHelper;
import jp.sf.pal.vfs.helper.FileParameterHelper;
import jp.sf.pal.vfs.util.VFSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class FileServlet extends HttpServlet {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -6698034002750044219L;

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(FileServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException {
        // String uri = request.getParameter("uri");
        String id = (String) request.getParameter("id");
        if (log.isDebugEnabled()) {
            log.debug("doGet() - id=" + id);
        }

        FileParameterHelper fileParam = (FileParameterHelper) request
                .getSession().getAttribute(VFSConstants.DOWNLOAD_OBJECT);
        if (fileParam != null) {
            FileSystemManager fsManager = VFSUtil.getFileSystemManager();
            FileObject currentObject = fsManager
                    .resolveFile(fileParam.getURI());

            if (currentObject.exists()) {
                DownloadHelper downloadHelper = (DownloadHelper) SingletonS2ContainerFactory
                        .getContainer().getComponent(DownloadHelper.class);

                downloadHelper.setContentType(fileParam.getContentType());
                downloadHelper.setFilename(fileParam.getBaseName());
                downloadHelper.writeResponse(currentObject.getContent()
                        .getInputStream());
            } else {
                // TODO i18n
                response.sendError(HttpServletResponse.SC_NOT_FOUND,
                        "Cannot find " + fileParam.getURI());
            }
        } else {
            // TODO i18n
            response.sendError(HttpServletResponse.SC_NOT_FOUND, "Invalid id: "
                    + id);
        }
    }

}
