/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.web.navigator;

import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.vfs.VFSConstants;
import jp.sf.pal.vfs.util.VFSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class CreateNewFilePage extends DefaultPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(CreateNewFilePage.class);

    private String newFile;

    private String type;

    public CreateNewFilePage(S2Container container) {
        super(container);
    }

    public String next() {
        if (!VFSUtil.checkPath(getUri())) {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("access denied.");
            setUri(VFSUtil.getDefaultUri());
            return VFSConstants.DISPLAY_FOLDER_LIST_PAGE;
        }

        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap();
        sessionMap.put(VFSConstants.NEW_FILE_CONTENT_FILE_NAME, getNewFile());
        sessionMap.put(VFSConstants.NEW_FILE_CONTENT_FILE_TYPE, getType());

        if (log.isDebugEnabled()) {
            log.debug("next() newFile=" + newFile);
            log.debug("next() type=" + type);
        }

        return goWriteNewFileContentPage();
    }

    public SelectItem[] getTypes() {
        // TODO I18N
        return new SelectItem[] { new SelectItem("TEXT", "Text"),
                new SelectItem("HTML", "Html") };
    }

    /**
     * @return Returns the newFile.
     */
    public String getNewFile() {
        return newFile;
    }

    /**
     * @param newFile
     *            The newFile to set.
     */
    public void setNewFile(String newFile) {
        this.newFile = newFile;
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(String type) {
        this.type = type;
    }
}
