/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.vfs.web.navigator;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;

import javax.faces.context.FacesContext;

import jp.sf.pal.vfs.VFSConstants;
import jp.sf.pal.vfs.util.VFSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.seasar.framework.container.S2Container;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class WriteNewFileContentPage extends DefaultPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(WriteNewFileContentPage.class);

    private String text;

    public WriteNewFileContentPage(S2Container container) {
        super(container);
    }

    public String create() {
        if (!VFSUtil.checkPath(getUri())) {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("access denied.");
            setUri(VFSUtil.getDefaultUri());
            return VFSConstants.DISPLAY_FOLDER_LIST_PAGE;
        }

        if (log.isDebugEnabled()) {
            log.debug("create() text=" + getText());
        }

        try {
            FileSystemManager fsManager = VFSUtil.getFileSystemManager();
            FileObject newFileObject = fsManager.resolveFile(getUri() + "/"
                    + getNewFile());

            // TODO add confirmation
            // if (!newFileObject.exists())
            // {
            // TODO should catch exception to check if it's created
            newFileObject.createFile();
            Writer writer = null;
            try {
                writer = new OutputStreamWriter(newFileObject.getContent()
                        .getOutputStream(), "UTF-8");
                writer.write(getText());
                writer.flush();
            } catch (UnsupportedEncodingException e) {
                log.warn("Wrong encoding.");
                // TODO I18N
                FacesMessageUtil.addWarnMessage("Wrong encoding.");
            } catch (IOException e) {
                log.warn("Cannot write the content.");
                // TODO I18N
                FacesMessageUtil.addWarnMessage("Cannot write the content.");
            } finally {
                if (writer != null) {
                    try {
                        writer.close();
                    } catch (IOException e) {
                    }
                }
            }

            // TODO I18N
            FacesMessageUtil
                    .addInfoMessage("Created new file: " + getNewFile());
            return goDisplayFolderListPage();
            // }
        } catch (FileSystemException e) {
            // TODO I18N
            FacesMessageUtil.addInfoMessage("Failed to create the new file: "
                    + getNewFile(), e.toString());
            log.error("Failed to create the new file: " + getNewFile(), e);
        }
        return null;
    }

    /**
     * @return Returns the newFile.
     */
    public String getNewFile() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap();
        return (String) sessionMap.get(VFSConstants.NEW_FILE_CONTENT_FILE_NAME);
    }

    /**
     * @return the type
     */
    public String getType() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap();
        return (String) sessionMap.get(VFSConstants.NEW_FILE_CONTENT_FILE_TYPE);
    }

    /**
     * @return the text
     */
    public String getText() {
        return text;
    }

    /**
     * @param text
     *            the text to set
     */
    public void setText(String text) {
        this.text = text;
    }
}
