<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

	<h:form>
	<t:div style="text-align: left;width: 100%;">

		<h:commandButton image="#{navigator_createNewFilePage.createNewFileImage}"
			alt="Create New File" title="Create New File" rendered="#{navigator_createNewFilePage.renderCreateNewFile}"
			action="#{navigator_createNewFilePage.goCreateNewFilePage}" immediate="true" />
		<h:commandButton image="#{navigator_createNewFilePage.createNewFolderImage}"
			alt="Create New Folder" title="Create New Folder" rendered="#{navigator_createNewFilePage.renderCreateNewFolder}"
			action="#{navigator_createNewFilePage.goCreateNewFolderPage}" immediate="true" />
		<h:commandButton image="#{navigator_createNewFilePage.uploadFileImage}"
			alt="Upload File" title="Upload File" rendered="#{navigator_createNewFilePage.renderUploadFile}"
			action="#{navigator_createNewFilePage.goUploadFilePage}" immediate="true" />

	</t:div>

	<t:div style="text-align: left;width: 100%;">
		<h:panelGrid columns="3">

				<h:outputText value="URI:" styleClass="portlet-form-field" />
				<h:outputText value="#{navigator_createNewFilePage.uri}" styleClass="portlet-form-field" />
				<h:commandButton type="submit" value="Back" immediate="true"
					action="#{navigator_createNewFilePage.goDisplayFolderListPage}" styleClass="portlet-form-button" />

		</h:panelGrid>
	</t:div>

	<h:messages styleClass="portlet-msg-success"
		errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
		warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="2">
			<h:outputText value="New File:" styleClass="portlet-form-field" />
			<h:inputText id="newFile" value="#{navigator_createNewFilePage.newFile}"
				required="true" styleClass="portlet-form-field-label" />

			<h:selectOneMenu value="#{navigator_createNewFilePage.type}">
				<f:selectItems value="#{navigator_createNewFilePage.types}" />
			</h:selectOneMenu>
			<h:commandButton value="Next" action="#{navigator_createNewFilePage.next}"
				styleClass="portlet-form-button" />
		</h:panelGrid>
	</h:form>

</f:view>

