<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

	<h:form>

	<t:div style="text-align: left;width: 100%;">

		<h:commandButton image="#{navigator_displayFolderListPage.createNewFileImage}"
			alt="Create New File" title="Create New File" rendered="#{navigator_createNewFilePage.renderCreateNewFile}"
			action="#{navigator_displayFolderListPage.goCreateNewFilePage}" immediate="true" />
		<h:commandButton image="#{navigator_displayFolderListPage.createNewFolderImage}"
			alt="Create New Folder" title="Create New Folder" rendered="#{navigator_createNewFilePage.renderCreateNewFolder}"
			action="#{navigator_displayFolderListPage.goCreateNewFolderPage}" immediate="true" />
		<h:commandButton image="#{navigator_displayFolderListPage.uploadFileImage}"
			alt="Upload File" title="Upload File" rendered="#{navigator_createNewFilePage.renderUploadFile}"
			action="#{navigator_displayFolderListPage.goUploadFilePage}" immediate="true" />

	</t:div>

	<t:div style="text-align: left;width: 100%;">
		<h:panelGrid columns="4">

			<h:outputLabel for="uri">
				<h:outputText value="URI:" styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="uri" value="#{navigator_displayFolderListPage.uri}"
				styleClass="portlet-form-field-label" size="50" />
			<h:panelGrid columns="2">
				<h:commandButton type="submit" value="Go"
					action="#{navigator_displayFolderListPage.go}" styleClass="portlet-form-button" />
			</h:panelGrid>
			<h:commandButton image="#{navigator_displayFolderListPage.openParentImage}"
				alt="Go to Parent Folder" title="Go to Parent Folder"
				action="#{navigator_displayFolderListPage.openParent}" immediate="true" />

		</h:panelGrid>
	</t:div>

	<h:messages styleClass="portlet-msg-success"
		errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
		warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

	<h:outputText value="#{navigator_displayFolderListPage.outputHtml}" escape="false" />


		<!-- Table -->
		<h:dataTable id="fileList" border="1" var="item" width="100%"
			value="#{navigator_displayFolderListPage.objects}" headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate">
			<h:column>
				<f:facet name="header">
					<h:outputText value="File Name" />
				</f:facet>
				<h:commandLink action="#{navigator_displayFolderListPage.select}">
					<h:outputText id="name" value="#{item.baseName}" />
				</h:commandLink>
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Size" />
				</f:facet>
				<h:outputText id="size" value="#{item.formattedSize}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Content Type" />
				</f:facet>
				<h:outputText id="contentType" value="#{item.contentType}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Date" />
				</f:facet>
				<h:outputText id="date" value="#{item.formattedLastModifiedTime}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Action" />
				</f:facet>
				<h:commandButton type="submit" alt="Delete" title="Delete"
					image="#{navigator_displayFolderListPage.trashImage}"
					action="#{navigator_displayFolderListPage.delete}"
					onclick="if(!confirm('Do you want to delete this file/directory?')) return false;" />
			</h:column>
		</h:dataTable>

	</h:form>
</f:view>

