<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

	<h:form>
	<t:div style="text-align: left;width: 100%;">

		<h:commandButton image="#{navigator_writeNewFileContentPage.createNewFileImage}"
			alt="Create New File" title="Create New File" rendered="#{navigator_createNewFilePage.renderCreateNewFile}"
			action="#{navigator_writeNewFileContentPage.goCreateNewFilePage}" immediate="true" />
		<h:commandButton image="#{navigator_writeNewFileContentPage.createNewFolderImage}"
			alt="Create New Folder" title="Create New Folder" rendered="#{navigator_createNewFilePage.renderCreateNewFolder}"
			action="#{navigator_writeNewFileContentPage.goCreateNewFolderPage}" immediate="true" />
		<h:commandButton image="#{navigator_writeNewFileContentPage.uploadFileImage}"
			alt="Upload File" title="Upload File" rendered="#{navigator_createNewFilePage.renderUploadFile}"
			action="#{navigator_writeNewFileContentPage.goUploadFilePage}" immediate="true" />

	</t:div>

	<t:div style="text-align: left;width: 100%;">
		<h:panelGrid columns="3">

				<h:outputText value="URI:" styleClass="portlet-form-field" />
				<h:outputText value="#{navigator_writeNewFileContentPage.uri}" styleClass="portlet-form-field" />
				<h:commandButton type="submit" value="Back" immediate="true"
					action="#{navigator_writeNewFileContentPage.goDisplayFolderListPage}" styleClass="portlet-form-button" />

		</h:panelGrid>
	</t:div>

	<h:messages styleClass="portlet-msg-success"
		errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
		warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<t:htmlTag value="div">
			<h:panelGrid columns="3">
				<h:outputText value="File Name:" styleClass="portlet-form-field" />
				<h:outputText value="#{navigator_writeNewFileContentPage.newFile}"
					styleClass="portlet-form-field" />
				<h:commandButton value="Create New File"
					action="#{navigator_writeNewFileContentPage.create}"
					styleClass="portlet-form-button" />
			</h:panelGrid>
		</t:htmlTag>

		<t:htmlTag value="div" rendered="#{navigator_writeNewFileContentPage.type == 'TEXT'}">
			<h:inputTextarea value="#{navigator_writeNewFileContentPage.text}"
				style="height: 400px; width: 100%" />
		</t:htmlTag>

		<t:htmlTag value="div" rendered="#{navigator_writeNewFileContentPage.type == 'HTML'}">
			<t:inputHtml value="#{navigator_writeNewFileContentPage.text}"
				style="height: 400px; width: 100%" allowEditSource="true"
				showPropertiesToolBox="true" showLinksToolBox="true"
				showImagesToolBox="true" showTablesToolBox="true"
				showCleanupExpressionsToolBox="true" showDebugToolBox="false" />
		</t:htmlTag>

	</h:form>

</f:view>

