/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.web.editor;

import javax.faces.context.FacesContext;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dao.FolderNodeDao;
import jp.sf.pal.cms.dto.FolderNodeDto;
import jp.sf.pal.cms.util.CMSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;

/**
 * @author shinsuke
 * 
 */
public class CreateNewFolderPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(CreateNewFolderPage.class);

    private String path;

    private String name;

    private S2Container container;

    public CreateNewFolderPage() {
        Object obj = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap().get(CMSConstants.PATH);
        if (obj != null) {
            setPath((String) obj);
        } else {
            setPath(CMSConstants.ROOT_FOLDER);
        }
    }

    public String backToList() {
        CMSUtil.clearSession();
        return CMSConstants.DISPLAY_FOLDER_LIST_PAGE;
    }

    public String create() {
        FolderNodeDto folderNode = (FolderNodeDto) container
                .getComponent(FolderNodeDto.class);
        // S2Container container = SingletonS2ContainerFactory.getContainer();
        FolderNodeDao folderNodeDao = (FolderNodeDao) container
                .getComponent(FolderNodeDao.class);
        // FolderNodeDto folderNode = new FolderNodeDto();
        folderNode.setScope(CMSUtil.getScopeFromRequest());
        folderNode.setParentPath(getPath());
        folderNode.setName(getName());
        try {
            folderNodeDao.insert(folderNode);
            return CMSConstants.DISPLAY_FOLDER_LIST_PAGE;
        } catch (CMSException e) {
            log.error("Could not create the new folder: " + getName(), e);
        }
        return null;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the path.
     */
    public String getPath() {
        return path;
    }

    /**
     * @param path
     *            The path to set.
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }
}
