<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<h:form>
		<!-- MENU -->
		<t:div style="text-align: left;width: 100%;">

			<h:commandButton alt="Create New File" title="Create New File"
				value="Create New File"
				action="#{editor_displayFolderListPage.goCreateNewFile}"
				styleClass="portlet-form-button" immediate="true" />
			<h:commandButton alt="Create New Folder" title="Create New Folder"
				value="Create New Folder"
				action="#{editor_displayFolderListPage.goCreateNewFolder}"
				styleClass="portlet-form-button" immediate="true" />
			<h:commandButton alt="Store XML File" title="Store XML File"
				value="Store XML File"
				action="#{editor_displayFolderListPage.storeXmlFile}"
				styleClass="portlet-form-button" immediate="true" rendered="false" />

		</t:div>

		<t:div style="text-align: left;width: 100%;">
			<h:panelGrid columns="4">

				<h:outputLabel for="path">
					<h:outputText value="PATH:" styleClass="portlet-form-field" />
				</h:outputLabel>
				<h:inputText id="path" value="#{editor_displayFolderListPage.path}"
					styleClass="portlet-form-field-label" size="50" />
				<h:commandButton type="submit" value="Go"
					action="#{editor_displayFolderListPage.go}"
					styleClass="portlet-form-button" />
				<h:commandButton alt="Go to Parent Folder"
					title="Go to Parent Folder" value="Go to Parent Folder"
					action="#{editor_displayFolderListPage.goParentFolder}"
					styleClass="portlet-form-button" immediate="true" />

			</h:panelGrid>
		</t:div>
		
		<t:div style="text-align: left;width: 100%;">
          <h:panelGrid columns="1">
            <h:outputText value="Namespace: #{editor_displayFolderListPage.namespace}"/>  
            <h:outputText value="Default Path: none" rendered="#{editor_displayFolderListPage.defaultPath==''}"/>  
            <h:outputText value="Default Path: #{editor_displayFolderListPage.defaultPath}" rendered="#{editor_displayFolderListPage.defaultPath!=''}"/>  
          </h:panelGrid>
		</t:div>        
		

		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<!-- h:outputText value="#{editor_displayFolderListPage.outputHtml}" escape="false" / -->


		<!-- Table -->
		<h:dataTable id="fileList" border="1" var="objectNode" width="100%"
			value="#{editor_displayFolderListPage.objectNodes}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate">
			<h:column>
				<f:facet name="header">
					<h:outputText value="Name" />
				</f:facet>
				<t:div>
					<h:commandLink action="#{editor_displayFolderListPage.select}">
						<h:outputText id="name" value="#{objectNode.name}" />
					</h:commandLink>
					<h:outputText value="("
						rendered="#{objectNode.nodeType=='cms:folder'}" />
					<h:commandLink action="#{editor_displayFolderListPage.editFolder}"
						rendered="#{objectNode.nodeType=='cms:folder'}">
						<h:outputText id="editFolder" value="Edit" />
					</h:commandLink>
					<h:outputText value=")"
						rendered="#{objectNode.nodeType=='cms:folder'}" />
				</t:div>
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="Mime Type" />
				</f:facet>
				<h:outputText id="mimeType" value="#{objectNode.mimeType}"
					rendered="#{objectNode.nodeType=='cms:file'}" />
				<h:outputText id="mimeTypeNone" value="-"
					rendered="#{objectNode.nodeType=='cms:folder'}" />
			</h:column>
		</h:dataTable>

	</h:form>
</f:view>
