/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.dao.impl;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dao.PageNodeDao;
import jp.sf.pal.cms.dto.PageNodeDto;
import jp.sf.pal.cms.util.CMSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.jcr.SessionFactory;

/**
 * @author shinsuke
 * 
 */
public class PageNodeDaoImpl implements PageNodeDao {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(PageNodeDaoImpl.class);

    private SessionFactory sessionFactory_;

    private S2Container container;

    public PageNodeDaoImpl(SessionFactory sessionFactory) {
        sessionFactory_ = sessionFactory;
    }

    public PageNodeDto getPageNode(String name) throws CMSException {
        try {
            Session session = sessionFactory_.getSession();
            Node rn = session.getRootNode();
            Node pageNode = rn.getNode(CMSConstants.PAGE_NODE);
            Node targetNode = pageNode.getNode(name);
            PageNodeDto pageNodeDto = (PageNodeDto) container
                    .getComponent(PageNodeDto.class);
            // PageNodeDto pageNodeDto = new PageNodeDto();
            pageNodeDto.setName(name);
            pageNodeDto.setPath(targetNode.getProperty(
                    CMSConstants.PAGE_NODE_PATH_ATTR).getString());
            return pageNodeDto;
        } catch (PathNotFoundException e) {
            throw new CMSException("Could not find a page node. ", e);
        } catch (RepositoryException e) {
            throw new CMSException("Could not find a page node. ", e);
        }
    }

    public void insert(PageNodeDto pageNodeDto) throws CMSException {
        try {
            Session session = sessionFactory_.getSession();
            Node rn = session.getRootNode();
            Node pageNode = rn.getNode(CMSConstants.PAGE_NODE);
            Node targetNode = pageNode.addNode(pageNodeDto.getName());
            CMSUtil.setProperty(targetNode, CMSConstants.PAGE_NODE_PATH_ATTR,
                    pageNodeDto.getPath());
            session.save();
        } catch (PathNotFoundException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (ItemExistsException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (VersionException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (LockException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (ValueFormatException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Could not insert the page node. ", e);
        } catch (RepositoryException e) {
            throw new CMSException("Could not insert the page node. ", e);
        }
    }

    public void update(PageNodeDto pageNodeDto) throws CMSException {
        try {
            Session session = sessionFactory_.getSession();
            Node rn = session.getRootNode();
            Node pageNode = rn.getNode(CMSConstants.PAGE_NODE);
            Node targetNode = pageNode.getNode(pageNodeDto.getName());
            CMSUtil.setProperty(targetNode, CMSConstants.PAGE_NODE_PATH_ATTR,
                    pageNodeDto.getPath());
            session.save();
        } catch (PathNotFoundException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (VersionException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (LockException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (ValueFormatException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (ItemExistsException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Could not update the page node. ", e);
        } catch (RepositoryException e) {
            throw new CMSException("Could not update the page node. ", e);
        }
    }

    public void remove(PageNodeDto pageNodeDto) throws CMSException {
        try {
            Session session = sessionFactory_.getSession();
            Node rn = session.getRootNode();
            Node pageNode = rn.getNode(CMSConstants.PAGE_NODE);
            Node targetNode = pageNode.getNode(pageNodeDto.getName());
            targetNode.remove();
            session.save();
        } catch (PathNotFoundException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (VersionException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (LockException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (ItemExistsException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Could not remove the page node. ", e);
        } catch (RepositoryException e) {
            throw new CMSException("Could not remove the page node. ", e);
        }
    }

    public void initPageNode() throws CMSException {
        try {
            Session session = sessionFactory_.getSession();
            Node rn = session.getRootNode();
            try {
                rn.getNode(CMSConstants.PAGE_NODE);
            } catch (PathNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not find a page node. Creating it...");
                }
                rn.addNode(CMSConstants.PAGE_NODE);
            }
            session.save();
        } catch (ItemExistsException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (PathNotFoundException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (VersionException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (LockException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Could not create a page node. ", e);
        } catch (RepositoryException e) {
            throw new CMSException("Could not create a page node. ", e);
        }
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }

}
