<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

	<h:form>

		<t:div style="text-align: left;width: 100%;">
			<h:panelGrid columns="2">

				<h:outputText value="PATH:" styleClass="portlet-form-field" />
				<h:outputText id="path" value="#{editor_writeTextContentPage.path}"
					styleClass="portlet-form-field" />

			</h:panelGrid>
		</t:div>

		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<t:div style="text-align: left;width: 100%;">
			<h:panelGrid columns="1">

				<h:panelGrid columns="3">

					<h:outputText value="Name:" styleClass="portlet-form-field" />
					<h:outputText id="name" value="#{editor_writeTextContentPage.name}"
						styleClass="portlet-form-field-label" />
					<h:outputText value="" styleClass="portlet-form-field" />

					<h:outputLabel for="title">
						<h:outputText value="Title:" styleClass="portlet-form-field" />
					</h:outputLabel>
					<h:inputText id="title" value="#{editor_writeTextContentPage.title}"
						styleClass="portlet-form-field-label" size="30" />
					<h:message for="title" />

					<h:outputLabel for="description">
						<h:outputText value="Description:" styleClass="portlet-form-field" />
					</h:outputLabel>
					<h:inputText id="description"
						value="#{editor_writeTextContentPage.description}"
						styleClass="portlet-form-field-label" size="30" />
					<h:message for="description" />

					<h:outputLabel for="mimeType">
						<h:outputText value="MIME Type:" styleClass="portlet-form-field" />
					</h:outputLabel>
					<h:inputText id="mimeType"
						value="#{editor_writeTextContentPage.mimeType}"
						styleClass="portlet-form-field-label" size="30" />
					<h:message for="mimeType" />

					<h:outputLabel for="encoding">
						<h:outputText value="Encoding:" styleClass="portlet-form-field" />
					</h:outputLabel>
					<h:inputText id="encoding"
						value="#{editor_writeTextContentPage.encoding}"
						styleClass="portlet-form-field-label" size="30" />
					<h:message for="encoding" />

				</h:panelGrid>

				<h:outputLabel for="content">
					<h:outputText value="Content:" styleClass="portlet-form-field" />
				</h:outputLabel>
				<h:message for="content" />
				<h:inputTextarea id="content"
					value="#{editor_writeTextContentPage.content}"
					styleClass="portlet-form-field-label" cols="60" rows="20" />

				<f:facet name="footer">
					<h:panelGrid columns="1">
						<h:panelGrid columns="1">
							<h:commandButton type="submit" value="Finish"
								action="#{editor_writeTextContentPage.save}"
								styleClass="portlet-form-button" />
						</h:panelGrid>
						<h:panelGrid columns="1">
							<h:commandButton type="submit" value="Back to Folder List"
								action="#{editor_writeTextContentPage.backToList}"
								styleClass="portlet-form-button" immediate="true" />
						</h:panelGrid>
					</h:panelGrid>
				</f:facet>

			</h:panelGrid>
		</t:div>

	</h:form>
</f:view>
