/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.vfs;

public class VFSConstants {
    public static final String CONSTANT_PREFIX = "jp.sf.pal.vfs.";

    public static long MAX_DEFAULT_EXPIRE_TIME = 5000;

    public static int DOWNLOAD_CACHE_SIZE = 1024;

    public static int MAX_ID_LENGTH = 100;

    public static String DOWNLOAD_OBJECT = CONSTANT_PREFIX + "DOWNLOAD_OBJECT";

    public static String NEW_FILE_CONTENT_FILE_NAME = CONSTANT_PREFIX
            + "NEW_FILE_CONTENT_FILE_NAME";

    public static String NEW_FILE_CONTENT_FILE_TYPE = CONSTANT_PREFIX
            + "NEW_FILE_CONTENT_FILE_TYPE";

    public static String URI = CONSTANT_PREFIX + "URI";

    public static String DEFAULT_URI = "default-uri";

    public static String OUTPUT_HTML = CONSTANT_PREFIX + "OUTPUT_HTML";

    public static final String DISPLAY_FOLDER_LIST_PAGE = "DISPLAY_FOLDER_LIST_PAGE";

    public static final String CREATE_NEW_FILE_PAGE = "CREATE_NEW_FILE_PAGE";

    public static final String WRITE_NEW_FILE_CONTENT_PAGE = "WRITE_NEW_FILE_CONTENT_PAGE";

    public static final String CREATE_NEW_FOLDER_PAGE = "CREATE_NEW_FOLDER_PAGE";

    public static final String UPLOAD_FILE_PAGE = "UPLOAD_FILE_PAGE";

    public static final String RENDER_CREATE_NEW_FILE = "render-create-new-file";

    public static final String RENDER_CREATE_NEW_FOLDER = "render-create-new-folder";

    public static final String RENDER_UPLOAD_FILE = "render-upload-file";

    public static final String ACCEPT_PATHS = "accept-paths";

    public static final String DENY_PATHS = "deny-paths";

    public static final String TRUE = "true";

    public static final String FALSE = "false";

    public static final String OCTET_STREAM = "application/octet-stream";

    public static final String NULL_VALUE = "---";
}
