<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>

<h:form>
	<t:div style="text-align: left;width: 100%;">

		<h:commandButton image="#{navigator_uploadFilePage.createNewFileImage}"
			alt="Create New File" title="Create New File" rendered="#{navigator_createNewFilePage.renderCreateNewFile}"
			action="#{navigator_uploadFilePage.goCreateNewFilePage}" immediate="true" />
		<h:commandButton image="#{navigator_uploadFilePage.createNewFolderImage}"
			alt="Create New Folder" title="Create New Folder" rendered="#{navigator_createNewFilePage.renderCreateNewFolder}"
			action="#{navigator_uploadFilePage.goCreateNewFolderPage}" immediate="true" />
		<h:commandButton image="#{navigator_uploadFilePage.uploadFileImage}"
			alt="Upload File" title="Upload File" rendered="#{navigator_createNewFilePage.renderUploadFile}"
			action="#{navigator_uploadFilePage.goUploadFilePage}" immediate="true" />

	</t:div>

	<t:div style="text-align: left;width: 100%;">
		<h:panelGrid columns="3">

				<h:outputText value="URI:" styleClass="portlet-form-field" />
				<h:outputText value="#{navigator_uploadFilePage.uri}" styleClass="portlet-form-field" />
				<h:commandButton type="submit" value="Back" immediate="true"
					action="#{navigator_uploadFilePage.goDisplayFolderListPage}" styleClass="portlet-form-button" />

		</h:panelGrid>
	</t:div>

	<h:messages styleClass="portlet-msg-success"
		errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
		warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

</h:form>

	<h:form enctype="multipart/form-data">
		<table border="0">
			<tr>
				<td><h:outputText value="File:" styleClass="portlet-form-field" /></td>
				<td><t:inputFileUpload id="fileupload"
					value="#{navigator_uploadFilePage.uploadedFile}" storage="file"
					required="true" styleClass="portlet-form-field-label" size="40" /></td>
			</tr>
			<tr>
				<td align="center" colspan="2"><h:commandButton value="Upload"
					action="#{navigator_uploadFilePage.upload}" styleClass="portlet-form-button" /></td>
			</tr>
		</table>
	</h:form>

</f:view>

