/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.web.viewer;

import jp.sf.pal.wiki.service.WikiContentService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;

/**
 * @author shinsuke
 * 
 */
public class DisplayContentPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(DisplayContentPage.class);

    /**
     * 
     */
    private String content;

    private String pageName;

    private S2Container container;

    private WikiContentService wikiContentService;

    public DisplayContentPage() {
    }

    /**
     * @return
     */
    public String initialize() {
        return null;
    }

    /**
     * @return
     */
    public String prerender() {
        if (log.isDebugEnabled()) {
            log.debug("prerender()");
        }

        // WikiContentService wikiContentService = (WikiContentService)
        // container
        // .getComponent(WikiContentService.class);
        setPageName(getWikiContentService().getCurrentPageName());
        setContent(getWikiContentService().getCurrentConvertedContent());
        return null;
    }

    /**
     * @return the yourName
     */
    public String getContent() {
        return content;
    }

    /**
     * @param content
     *            the content to set
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }

    /**
     * @return Returns the pageName.
     */
    public String getPageName() {
        return pageName;
    }

    /**
     * @param pageName
     *            The pageName to set.
     */
    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    /**
     * @return Returns the wikiContentService.
     */
    public WikiContentService getWikiContentService() {
        return wikiContentService;
    }

    /**
     * @param wikiContentService
     *            The wikiContentService to set.
     */
    public void setWikiContentService(WikiContentService wikiContentService) {
        this.wikiContentService = wikiContentService;
    }

}
