/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.deployer;

import jp.sf.pal.admin.entity.PortletApplication;

public class DeploymentStatus
{
    public static final int DEPLOYED = 2;

    public static final int DEPLOYING = 1;

    public static final int READY = 0;

    private long startTime;

    public int status;

    public PortletApplication portletApplication;

    public DeploymentStatus(PortletApplication portletApplication)
    {
        startTime = 0;
        status = READY;
        this.portletApplication = portletApplication;
    }

    /**
     * @return the status
     */
    public int getStatus()
    {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(int status)
    {
        this.status = status;
    }

    /**
     * @return the portletApplication
     */
    public PortletApplication getPortletApplication()
    {
        return portletApplication;
    }

    /**
     * @param portletApplication the portletApplication to set
     */
    public void setPortletApplication(PortletApplication portletApplication)
    {
        this.portletApplication = portletApplication;
    }

    /**
     * @return the startTime
     */
    public long getStartTime()
    {
        return startTime;
    }

    /**
     * @param startTime the startTime to set
     */
    public void setStartTime(long startTime)
    {
        this.startTime = startTime;
    }
}
