/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.dxo;

import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.entity.User;
import jp.sf.pal.admin.web.user.AbstractUserPage;
import jp.sf.pal.admin.web.user.UserEditPage;

public interface UserDxo
{
    public void convert(List<User> entities, List<Map<String, Object>> list);

    public void convert(AbstractUserPage page, User entity);

    public void convert(User entity, AbstractUserPage page);

    public void convert(User entity, UserEditPage page);

    public void convert(UserEditPage page, User entity);

}
