/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.entity;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PortletApplication implements Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = 904304488157108100L;

    public static final String PACKAGING_TYPE_WAR = "war";

    public static final String PACKAGING_TYPE_JAR = "jar";

    private String name;

    private String path;

    private String version;

    private int status;

    private int applicationType;

    private Date created = null;

    private Date lastModified = null;

    private String portletSpecVersion = null;

    private String groupId = null;

    private String artifactId = null;

    private String packaging = null;

    private String description = null;

    private List<String> tags = new ArrayList<String>();

    private String publisherName = null;

    private String publisherUrl = null;

    private String binaryUrl = null;

    private String sourceUrl = null;

    private String imageUrl = null;

    //TODO
    //    private Map dependencies;

    private String licenseName = null;

    private String licenseUrl = null;

    private String compiledJDKVersion = null;

    private List<Locale> supportedLocales = new ArrayList<Locale>();

    public void addTag(String category)
    {
        tags.add(category);
    }

    public void addSupportedLocale(Locale locale)
    {
        supportedLocales.add(locale);
    }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the path
     */
    public String getPath()
    {
        return path;
    }

    /**
     * @param path the path to set
     */
    public void setPath(String path)
    {
        this.path = path;
    }

    /**
     * @return the status
     */
    public int getStatus()
    {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(int status)
    {
        this.status = status;
    }

    /**
     * @return the version
     */
    public String getVersion()
    {
        return version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(String version)
    {
        this.version = version;
    }

    /**
     * @return the applicationType
     */
    public int getApplicationType()
    {
        return applicationType;
    }

    /**
     * @param applicationType the applicationType to set
     */
    public void setApplicationType(int applicationType)
    {
        this.applicationType = applicationType;
    }

    /**
     * @return the artifactId
     */
    public String getArtifactId()
    {
        return artifactId;
    }

    /**
     * @param artifactId the artifactId to set
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    }

    /**
     * @return the binaryUrl
     */
    public String getBinaryUrl()
    {
        return binaryUrl;
    }

    /**
     * @param binaryUrl the binaryUrl to set
     */
    public void setBinaryUrl(String binaryUrl)
    {
        this.binaryUrl = binaryUrl;
    }

    /**
     * @return the compiledJDKVersion
     */
    public String getCompiledJDKVersion()
    {
        return compiledJDKVersion;
    }

    /**
     * @param compiledJDKVersion the compiledJDKVersion to set
     */
    public void setCompiledJDKVersion(String compiledJDKVersion)
    {
        this.compiledJDKVersion = compiledJDKVersion;
    }

    /**
     * @return the created
     */
    public Date getCreated()
    {
        return created;
    }

    /**
     * @param created the created to set
     */
    public void setCreated(Date created)
    {
        this.created = created;
    }

    /**
     * @return the description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * @return the groupId
     */
    public String getGroupId()
    {
        return groupId;
    }

    /**
     * @param groupId the groupId to set
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    }

    /**
     * @return the imageUrl
     */
    public String getImageUrl()
    {
        return imageUrl;
    }

    /**
     * @param imageUrl the imageUrl to set
     */
    public void setImageUrl(String imageUrl)
    {
        this.imageUrl = imageUrl;
    }

    /**
     * @return the lastModified
     */
    public Date getLastModified()
    {
        return lastModified;
    }

    /**
     * @param lastModified the lastModified to set
     */
    public void setLastModified(Date lastModified)
    {
        this.lastModified = lastModified;
    }

    /**
     * @return the licenseName
     */
    public String getLicenseName()
    {
        return licenseName;
    }

    /**
     * @param licenseName the licenseName to set
     */
    public void setLicenseName(String licenseName)
    {
        this.licenseName = licenseName;
    }

    /**
     * @return the licenseUrl
     */
    public String getLicenseUrl()
    {
        return licenseUrl;
    }

    /**
     * @param licenseUrl the licenseUrl to set
     */
    public void setLicenseUrl(String licenseUrl)
    {
        this.licenseUrl = licenseUrl;
    }

    /**
     * @return the packaging
     */
    public String getPackaging()
    {
        return packaging;
    }

    /**
     * @param packaging the packaging to set
     */
    public void setPackaging(String packaging)
    {
        this.packaging = packaging;
    }

    /**
     * @return the portletSpecVersion
     */
    public String getPortletSpecVersion()
    {
        return portletSpecVersion;
    }

    /**
     * @param portletSpecVersion the portletSpecVersion to set
     */
    public void setPortletSpecVersion(String portletSpecVersion)
    {
        this.portletSpecVersion = portletSpecVersion;
    }

    /**
     * @return the publisherName
     */
    public String getPublisherName()
    {
        return publisherName;
    }

    /**
     * @param publisherName the publisherName to set
     */
    public void setPublisherName(String publisherName)
    {
        this.publisherName = publisherName;
    }

    /**
     * @return the publisherUrl
     */
    public String getPublisherUrl()
    {
        return publisherUrl;
    }

    /**
     * @param publisherUrl the publisherUrl to set
     */
    public void setPublisherUrl(String publisherUrl)
    {
        this.publisherUrl = publisherUrl;
    }

    /**
     * @return the sourceUrl
     */
    public String getSourceUrl()
    {
        return sourceUrl;
    }

    /**
     * @param sourceUrl the sourceUrl to set
     */
    public void setSourceUrl(String sourceUrl)
    {
        this.sourceUrl = sourceUrl;
    }

    /**
     * @return the supportedLocales
     */
    public List<Locale> getSupportedLocales()
    {
        return supportedLocales;
    }

    /**
     * @param supportedLocales the supportedLocales to set
     */
    public void setSupportedLocales(List<Locale> supportedLocales)
    {
        this.supportedLocales = supportedLocales;
    }

    /**
     * @return the tags
     */
    public List<String> getTags()
    {
        return tags;
    }

    /**
     * @param tags the tags to set
     */
    public void setTags(List<String> tags)
    {
        this.tags = tags;
    }
}
