/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.entity;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.sf.pal.admin.PALAdminConstants;

public class User implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = -8545253440267174975L;

    private String name;

    private String password;

    private boolean updateRequired;

    private List<Role> roles;

    private List<Group> groups;

    private List<PrincipalRule> principalRules;

    private String expires;

    private Timestamp lastLogon;

    private boolean userEnabled;

    private Date expirationDate;

    public User()
    {
        roles = new ArrayList<Role>();
        groups = new ArrayList<Group>();
        principalRules = new ArrayList<PrincipalRule>();
    }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the password
     */
    public String getPassword()
    {
        return password;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password)
    {
        this.password = password;
    }

    /**
     * @return the profileRules
     */
    public List<PrincipalRule> getPrincipalRules()
    {
        return principalRules;
    }

    /**
     * @param profileRules the profileRules to set
     */
    public void setPrincipalRules(List<PrincipalRule> profileRules)
    {
        this.principalRules = profileRules;
    }

    /**
     * @return the roles
     */
    public List<Role> getRoles()
    {
        return roles;
    }

    /**
     * @param roles the roles to set
     */
    public void setRoles(List<Role> roles)
    {
        this.roles = roles;
    }

    /**
     * @return the groups
     */
    public List<Group> getGroups()
    {
        return groups;
    }

    /**
     * @param groups the groups to set
     */
    public void setGroups(List<Group> groups)
    {
        this.groups = groups;
    }

    /**
     * @return the updateRequired
     */
    public boolean isUpdateRequired()
    {
        return updateRequired;
    }

    /**
     * @param updateRequired the updateRequired to set
     */
    public void setUpdateRequired(boolean updateRequired)
    {
        this.updateRequired = updateRequired;
    }

    // Aditional method

    public void setRoleName(String rolename)
    {
        Role role = new Role();
        role.setName(rolename);
        roles.add(role);
    }

    public String getRoleName()
    {
        if (!roles.isEmpty())
        {
            return roles.get(0).getName();
        }
        return null;
    }

    public void setGroupName(String groupname)
    {
        Group group = new Group();
        group.setName(groupname);
        groups.add(group);
    }

    public String getGroupName()
    {
        if (!groups.isEmpty())
        {
            return groups.get(0).getName();
        }
        return null;
    }

    public void setPrincipalRuleName(String principalRulename)
    {
        PrincipalRule principalRule = new PrincipalRule();
        principalRule.setProfilingRuleName(principalRulename);
        principalRule.setLocatorName(PALAdminConstants.LOCATOR_PAGE);
        principalRules.add(principalRule);
    }

    public String getPrincipalRuleName()
    {
        if (!principalRules.isEmpty())
        {
            return principalRules.get(0).getProfilingRuleName();
        }
        return null;
    }

    /**
     * @return the expires
     */
    public String getExpires()
    {
        return expires;
    }

    /**
     * @param expires the expires to set
     */
    public void setExpires(String expires)
    {
        this.expires = expires;
    }

    /**
     * @return the lastLogon
     */
    public Timestamp getLastLogon()
    {
        return lastLogon;
    }

    /**
     * @param lastLogon the lastLogon to set
     */
    public void setLastLogon(Timestamp lastLogon)
    {
        this.lastLogon = lastLogon;
    }

    /**
     * @return the userEnabled
     */
    public boolean isUserEnabled()
    {
        return userEnabled;
    }

    /**
     * @param userEnabled the userEnabled to set
     */
    public void setUserEnabled(boolean userEnabled)
    {
        this.userEnabled = userEnabled;
    }

    /**
     * @return the expirationDate
     */
    public Date getExpirationDate()
    {
        return expirationDate;
    }

    /**
     * @param expirationDate the expirationDate to set
     */
    public void setExpirationDate(Date expirationDate)
    {
        this.expirationDate = expirationDate;
    }
}
