/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.dxo.GroupDxo;
import jp.sf.pal.admin.entity.Group;
import jp.sf.pal.admin.logic.SecurityProviderLogic;
import jp.sf.pal.admin.pager.GroupPager;
import jp.sf.pal.admin.util.PagerUtil;
import jp.sf.pal.admin.web.group.AbstractGroupPage;
import jp.sf.pal.admin.web.group.GroupListPage;

public class GroupManagementService implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 1449932208552950052L;

    private GroupPager groupPager;

    private SecurityProviderLogic securityProviderLogic;

    private GroupDxo groupDxo;

    /**
     * @return the groupDxo
     */
    public GroupDxo getGroupDxo()
    {
        return groupDxo;
    }

    /**
     * @param groupDxo the groupDxo to set
     */
    public void setGroupDxo(GroupDxo groupDxo)
    {
        this.groupDxo = groupDxo;
    }

    /**
     * @return the groupPager
     */
    public GroupPager getGroupPager()
    {
        return groupPager;
    }

    /**
     * @param groupPager the groupPager to set
     */
    public void setGroupPager(GroupPager groupPager)
    {
        this.groupPager = groupPager;
    }

    /**
     * @return the securityProviderLogic
     */
    public SecurityProviderLogic getSecurityProviderLogic()
    {
        return securityProviderLogic;
    }

    /**
     * @param securityProviderLogic the securityProviderLogic to set
     */
    public void setSecurityProviderLogic(
            SecurityProviderLogic securityProviderLogic)
    {
        this.securityProviderLogic = securityProviderLogic;
    }

    public void insert(AbstractGroupPage page) throws PALAdminException
    {
        Group entity = new Group();
        groupDxo.convert(page, entity);
        securityProviderLogic.insertGroup(entity);
    }

    public void delete(AbstractGroupPage page) throws PALAdminException
    {
        Group entity = new Group();
        groupDxo.convert(page, entity);
        securityProviderLogic.deleteGroup(entity);
    }

    public void loadPage(GroupListPage page)
    {
        GroupPager pager = getGroupPager();

        // check page action
        PagerUtil.updatePageNumber(pager,
                PALAdminConstants.PREVIOUS_PAGE_NUMBER,
                PALAdminConstants.NEXT_PAGE_NUMBER);

        // set group list
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        groupDxo.convert(securityProviderLogic.getGroups(pager), list);
        PagerUtil.updatePagerPage(page, pager);
        page.setGroupItems(list);

    }
}
