/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.util;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.deployer.DeploymentStatus;

public class DeploymentUtil
{
    /**
     * @return the facesContext
     */
    private static FacesContext getFacesContext()
    {
        return FacesContext.getCurrentInstance();
    }

    public static DeploymentStatus getDeploymentStatus()
    {
        return (DeploymentStatus) getFacesContext().getExternalContext()
                .getApplicationMap().get(PALAdminConstants.DEPLOYMENT_STATUS);
    }

    public static void setDeploymentStatus(DeploymentStatus deploymentStatus)
    {
        getFacesContext().getExternalContext().getApplicationMap().put(
                PALAdminConstants.DEPLOYMENT_STATUS, deploymentStatus);
    }

    public static boolean isDeploying()
    {
        DeploymentStatus deploymentStatus = getDeploymentStatus();
        if (deploymentStatus == null)
        {
            return false;
        }
        if (deploymentStatus.getStatus() == DeploymentStatus.DEPLOYING)
        {
            return true;
        }
        return false;
    }

    public static boolean isReady()
    {
        DeploymentStatus deploymentStatus = getDeploymentStatus();
        if (deploymentStatus == null)
        {
            return true;
        }
        if (deploymentStatus.getStatus() != DeploymentStatus.DEPLOYING)
        {
            return true;
        }
        return false;
    }
}
